/*
 * ExioInBuffer.h
 *
 * Created: 2016.11.05
 *
 */
 
#ifndef _EXIOINBUFFER_H_
#define _EXIOINBUFFER_H_

#include "mbed.h"
#include "rtos.h"
#include "ExioMcp23s17.h"

class ExioInBuffer {
public:
    ExioInBuffer(ExioMcp23s17* device, ExioPort port) :
        _device(device),
        _port(port),
        _buffer(0x00),
        _timer(&ExioInBuffer::threadHelper, osTimerPeriodic, (void *)this)
    {
        // set the port as input
        _device->ioDirection(_port, 0xff);
        _device->ioPullup(_port, 0xff);
        _device->ioPolarity(_port, 0xff);
    }
    
    uint8_t readPort()
    {
        return _buffer;
    }
    
    void run(uint32_t millsec)
    {
        _timer.start(millsec);
    }
    
    void stop()
    {
        _timer.stop();
    }

protected:
    ExioMcp23s17* _device;
    ExioPort _port;
    uint8_t _buffer;
    RtosTimer _timer;
    
    static void threadHelper(const void* arg)
    {
        ExioInBuffer* instance = (ExioInBuffer*)arg;
        instance->update();
    }
    
    void update() {
        _buffer = _device->readPort(_port);
    }
};

#endif //_EXIOINBUFFER_H_