/**
 * =============================================================================
 * Rotary Encoder class (Version 0.0.1)
 * =============================================================================
 * Copyright (c) 2010 Shinichiro Nakamura (CuBeatSystems)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * =============================================================================
 */
 
/*
 * 2016.11.5 Customized for MCP23S17 Buffered Input by ryood
 */
#include "ExioBufferedRotaryEncoder.h"

/**
 * Create rotary encoder.
 * @param buffer
 * @param pin1
 * @param pin2
 * @param min Minimum value.
 * @param max Maximum value.
 * @param val Default value.
 */
ExioBufferedRotaryEncoder::ExioBufferedRotaryEncoder(
        ExioInBuffer* buffer, int pin1, int pin2,
        int min, int max, int val) 
    : min(min), max(max), val(val) 
{
    in1 = new ExioBufferedIn(buffer, pin1);
    in2 = new ExioBufferedIn(buffer, pin2);
    in1->mode(PullUp);
    in2->mode(PullUp);
    //ticker.attach_us(this, &ExioMcp23s17RotaryEncoder::func_ticker, 500);
}

/**
 * Dispose.
 */
ExioBufferedRotaryEncoder::~ExioBufferedRotaryEncoder() {
    delete in1;
    delete in2;
}

/**
 * Internal tick function.
 */
void ExioBufferedRotaryEncoder::func_ticker() {
    //static uint8_t code;

    code = (code << 2) + (((in1->read() << 1) | (in2->read() << 0)) & 3);
    code &= 15;
    switch (code) {
        case 0x7:
            if (min < val) {
                val--;
            } else {
                val = min;
            }
            break;
        case 0xd:
            if (val < max) {
                val++;
            } else {
                val = max;
            }
            break;
    }
}
