/*
 * ExioBufferdIn.h
 *
 * Created: 2016.11.05
 *
 */
#ifndef _EXIOBUFFEREDIN_H_
#define _EXIOBUFFEREDIN_H_

#include "mbed.h"
#include "rtos.h"
#include "ExioInBuffer.h"

class ExioBufferedIn
{
public:
    ExioBufferedIn(ExioInBuffer* buffer, int pin) :
        _buffer(buffer),
        _pin(pin)
    {
        
    }
    
    ~ExioBufferedIn() {}
    
    void mode(PinMode pull)
    {
        // Todo: impliment pullmode
        if (pull != PullUp) {
            error("ExioBufferedIn::mode() is not impl");
        }  
    }
    
    int read()
    {
        uint8_t v = _buffer->readPort();
        return (v & (1 << _pin)) ? 1 : 0;
    }
    
protected:
    ExioInBuffer* _buffer;
    int _pin;
};

#endif //_EXIOBUFFEREDIN_H_