/*
 * main.cpp
 * BaseMachineUIController Test
 *
 * mbed Rev 121 / mbed-rtos Rev 117
 *
 * 2016.11.06 Created
 *
 */

#include "mbed.h"
#include "rtos.h"
#include "AT24C1024.h"

#define UART_TRACE  (0)
#include "BaseMachineUIController.h"
#include "ExioInBuffer.h"
#include "ExioBufferedDebounceIn.h"
#include "Sequence.h"

const int samplingRate = 1;

BaseMachineUIController UIController;

uint8_t step = 0;
int isStepChanged = false;
bool isRunning = false;

int bpm = 125;
uint32_t tick = 0;
int noteLen;

void setNoteLen()
{
    noteLen = 15000 / ((long)bpm * samplingRate);
}
    
void stepUp(void const* args)
{
    tick++;
    if (tick == noteLen) {
        tick = 0;
        if (isRunning) {
            step++;
            if (step == 16)
            {
                step = 0;
            }
            UIController.setPlayingStep(step);
        }
    }
}

int main()
{    
    #if (UART_TRACE)
    printf("*** BaseMachineUIController Test***\r\n");
    #endif
    
    UIController.init();
            
    RtosTimer stepTimer(stepUp, osTimerPeriodic, (void *)0);
    stepTimer.start(samplingRate);
    setNoteLen();
    
    while (true)
    {
        UIController.update();

        isRunning = UIController.getIsRunning();
        bpm = UIController.getBpm();
        setNoteLen();
        
        Sequence sequences[SEQUENCE_N];
        UIController.getSequences(&sequences);
        
        OscillatorParam osc;
        UIController.getOscillatorParam(&osc);
        
        FilterParam flt;
        UIController.getFilterParam(&flt);
        
        EnvelopeParam env;
        UIController.getEnvelopeParam(&env);
        
        int accentLevel = UIController.getAccentLevel();
        int sequencePattern = UIController.getSequencePattern();        
        
        #if (UART_TRACE)
        printf("%d %d ", osc.waveShape, osc.pulseWidth); 
        printf("%d %d ", flt.cutoff, flt.resonance); 
        printf("%d %d %d %d %d ", env.level, env.length, env.duration, env.decay, env.sustain); 
        printf("%d %d %d\r\n", bpm, accentLevel, sequencePattern);
        for (int i = 0; i < SEQUENCE_N; i++) {
            printf("%d %d %d %d %d %u\r\n",
                i, 
                sequences[i].isNoteOn(),
                sequences[i].getPitch(),
                sequences[i].isTie(),
                sequences[i].isAccent(),
                (sequences[i].getFrequency10()) >> 16
            );
        }
        #endif
    }
}
