/*
 * BaseMachine_Common.h
 *
 * 2016.10.23
 *
 */

#define SPI_UI_TO_SEQUENCER_RATE    (1500000)   // Actual frequency about 1.3MHz
#define SPI_UI_TO_SEQUENCER_BITS    (8)
#define SPI_UI_TO_SEQUENCER_MODE    (0)
#define SEQUENCE_N  (16)

enum SequencerCmd {
    CMD_RCV_PLAYING_STEP = 0x01,
    CMD_RUN              = 0x11,
    CMD_BPM              = 0x12,
    CMD_ACCENT_LEVEL     = 0x13,
    CMD_WAVE_SHAPE       = 0x21,
    CMD_PULSE_WIDTH      = 0x22,
    CMD_CUTOFF           = 0x31,
    CMD_RESONANCE        = 0x32,
    CMD_LEVEL            = 0x41,
    CMD_DURATION         = 0x42,
    CMD_DECAY            = 0x43,
    CMD_SUSTAIN          = 0x44,
    CMD_NOTE             = 0x51,
    CMD_PITCH            = 0x52, 
};

const int baseNoteNumber = 36;

// Initial Sequence
const int noteOn[SEQUENCE_N] = { 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0 };
const int pitch[SEQUENCE_N]  = {36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36 };
const int tie[SEQUENCE_N]    = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
const int accent[SEQUENCE_N] = { 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0 };

