#ifndef _AVERAGE_MCP3008_H_
#define _AVERAGE_MCP3008_H_
 
#include "mbed.h"
#include "mcp3008.h"
 
class AverageMCP3008 {
public:
    AverageMCP3008(MCP3008* _m_p_mcp3008, int _bufferSize=8) : m_p_mcp3008(_m_p_mcp3008), bufferSize(_bufferSize) {
        buffer = new unsigned short*[8];
        for (int i = 0; i < 8; i++) {
            buffer[i] = new unsigned short[bufferSize];
            index[i] = 0;
        }
    }
    
    ~AverageMCP3008() {
        for (int i  = 0; i < 8; i++) {
            delete[] buffer[i];
        }
        delete[] buffer;
    }
    
    unsigned short read_input_u16(int channel) {
        channel &= 0x07;
        buffer[channel][index[channel]] = m_p_mcp3008->read_input_u16(channel);
        index[channel]++;
        if (index[channel] == bufferSize) {
            index[channel] = 0;
        }
        unsigned int sum = 0;
        for (int i = 0; i < bufferSize; i++) {
            sum += buffer[channel][i];
        }
        return sum / bufferSize;
    }
    
    float read_input(int channel) {
        unsigned short value = read_input_u16(channel);
        return (float)value * (1.0f / (float)0x03FF);
    }
 
private:
    MCP3008* m_p_mcp3008;
    int bufferSize;
    int index[8];
    unsigned short **buffer;
};
 
#endif //_AVERAGE_MCP3008_H_