/*
 * EnvelopeをMCP4922に出力するテスト
 *
 * 2016.06.23
 *
 */

#include "mbed.h"
#include "rtos.h"
#include "Envelope.h"
#include "SpiAmpController.h"

#define AMP_VREF    0x0fff
#define SPIM_RATE   1000000

const int envLength = 25;

AnalogIn levelIn(A0);
AnalogIn durationIn(A1);
AnalogIn decayIn(A2);
AnalogIn sustainIn(A3);

SPI spiM(SPI_MOSI, SPI_MISO, SPI_SCK);

int main()
{
    spiM.format(8, 0);
    spiM.frequency(SPIM_RATE);
       
    // Envelope(level, length, duration, decay, sustain)
    Envelope envelope(4095, envLength, envLength*3/4, envLength/2, 2047);
    SpiAmpController ampController(&spiM, D8, D7);
    ampController.setVref(AMP_VREF);
        
    printf("\r\n\n*** Amp Controller Test ***\r\n");
    envelope.init();
    int cnt = 0;
    //int vref = 0;
    int vref=0x0fff;
    while (true) {
        ampController.outDca(envelope.getModLevel());
        envelope.update();
        
        cnt++;
        if (cnt == envLength) {
            cnt = 0;
            envelope.setLevel(levelIn * 4095);
            envelope.setDuration(durationIn * envLength);
            envelope.setDecay(decayIn * envLength);
            envelope.setSustain(sustainIn * 4095);
            
            /*
            printf("%d\t%d\t%d\t%d\t%d\t\r\n",
                envelope.getLevel(), envelope.getLength(), envelope.getDuration(), envelope.getDecay(), envelope.getSustain());
            */
            envelope.init();
            ampController.setVref(vref);
            //vref += 0x10;
            if (vref > 0x0fff) {
                vref = 0;
            }
        }
        Thread::wait(5);
    }
}
