#include "st7735.h"
#include "display.h"
#include "mbed.h"
/**
*See display.h for instructions for functions.
*/
display::display(ST7735_LCD *disp)
{
    lcd = disp;
    lcd->Initialize();
    lcd->ClearScreen();
    
}
void display::print(char *str)
{
    //lcd->ClearScreen();
    lcd->SetFont( &TerminusFont );
    lcd->SetForeground(COLOR_BLACK);
    lcd->Print(debugstr, CENTER, 50);
    debugstr = str;
    lcd->SetForeground(COLOR_WHITE);
    lcd->Print(str, CENTER, 50);
}
void display::printrb(const char *str)
{
    lcd->SetForeground(COLOR_RED);
    lcd->Print(str, CENTER, 0);
    lcd->SetForeground(COLOR_CYAN);
    lcd->Print(str, CENTER, 25);
    lcd->SetForeground(COLOR_YELLOW);
    lcd->Print(str, CENTER, 50);
    lcd->SetForeground(COLOR_GREEN);
    lcd->Print(str, CENTER, 75);   
    
    
    
}
void display::blinktext(const char *str)
{
    lcd->SetForeground(COLOR_GREEN);
    wait(1);
    lcd->Print(str, CENTER, 55);
    lcd->SetForeground(COLOR_BLACK);
    wait(1);
    lcd->Print(str, CENTER, 55);    
}

void display::displayStr(char *newStrength)
{
    //lcd->ClearScreen();
    lcd->SetForeground(COLOR_BLACK);//Set to black to overwrite old text.
    lcd->Print("Strength: ", LEFT, 25);//Overwrite old text.
    lcd->Print(strength, CENTER, 25);
    strength = newStrength;//Store new text for overwriting later.
    lcd->SetForeground(COLOR_WHITE);//Set to white for printing.
    lcd->Print("Strength: ", LEFT, 25);//Print.
    lcd->Print(strength, CENTER, 25);
    
}

void display::displayDist(char *newDist)//Works identically to above.
{
    //lcd->ClearScreen();
    lcd->SetForeground(COLOR_BLACK);
    lcd->Print("Dist: ", LEFT, 75);
    lcd->Print(dist, CENTER, 75);
    dist = newDist;
    lcd->SetForeground(COLOR_WHITE);
    lcd->Print("Dist: ", LEFT, 75);
    lcd->Print(dist, CENTER, 75);    
    
}
void display::calibrationdist(char *str)
{
    lcd->ClearScreen();
    lcd->SetForeground(COLOR_RED);
    lcd->Print("CALIBRATION", CENTER, 25);
    lcd->SetForeground(COLOR_WHITE);
    lcd->Print("Place beacon: ", LEFT, 50);
    lcd->Print(str, RIGHT, 50);
    lcd->Print("Then press button", LEFT, 75);


}
void display::calibrationunl(void)
{
    lcd->ClearScreen();
    lcd->SetForeground(COLOR_RED);
    lcd->Print("CALIBRATION", CENTER, 25);
    lcd->SetForeground(COLOR_WHITE);
    lcd->Print("Turn off Beacon", LEFT, 50);
    lcd->Print("Then press button", LEFT, 75);
    lcd->Print("Hold button to skip.", LEFT, 90);
    
    
}
void display::clearscreen(void)
{
  lcd->ClearScreen();  
    
}    