#include "st7735.h"

class display
{
    ST7735_LCD *lcd;
    char *debugstr;
    char *strength;
    char *dist;
    
    public:
    
    display(ST7735_LCD *disp);
    
    /**
    *Debug print that prints text in center of screen.
    *Will overwrite old text.
    */
    void print(char *str);
    /**
    *Test function that prints a string repeatedly in a rainbow fashion.
    */
    void printrb(const char *str);
    /**
    *Debug function that blinks text.
    */
    void blinktext(const char *str);
    
    /**
    *Displays the the strength on the screen, on the first line.
    *newStrength is the number in the form of a string, with units as
    *desired. Prints in format "Strength:newStrength". Will overwrite old
    *value automatically.
    */
    void displayStr(char *newStrength);
    
    /**
    *Works identically to displayStrength, but on second line with distance.
    *Prints in format "Dist:newDist". Units must be in string as desired.
    *Will overwrite old value automatically.
    */
    void displayDist(char * newDist);
};