#include "mbed.h"
#include "m3pi.h"
#include "PinDetect.h"

m3pi m3pi(p23,p9,p10);
PinDetect  pin( p21 );
bool advance = false;
Timer timer;
int leds = 0;

inline int ledHelper(bool on1,bool on2,bool on3,bool on4,bool on5,bool on6,bool on7,bool on8)
{
    return (on8 << 7) | (on7 << 6) | (on6 << 5) | (on5 << 4) | (on4 << 3) | (on3 << 2) | (on2 << 1) | (on1);
}

int setLeds(int newLeds)
{
    int i;
    for (i = 0; i < 8; i++)
    {
        if (newLeds & (1 << i))
            leds |= 1 << i;
        else
            leds &= ~(1 << i);
        m3pi.leds(leds);
        wait(0.0005);
    }
}


 void keyReleased( void ) {
    advance = true;
 }

// Ben's code
// through trial and error, found out that a full rotation takes ~240 ms
int main() {
    float pixel_width = 0.002;
    float space_width = pixel_width*2;
    int rotation_time_ms = 234;
   
    pin.mode( PullUp );
    pin.attach_deasserted( &keyReleased );
    pin.setSampleFrequency(); // Defaults to 20ms.
    
    m3pi.cls();
    m3pi.locate(0,1);
    m3pi.printf("%fV       ",m3pi.battery());
    
    wait(1.0);
    timer.start();
    while(1)
    {
        while(!advance);
        advance = false;
        
        m3pi.left_motor(-1.0);
        m3pi.right_motor(1.0);        
        while(1)
        {
            timer.reset();
            //H
            setLeds(ledHelper(1,1,1,1,1,1,1,1));
            wait(pixel_width);
            setLeds(ledHelper(0,0,0,1,1,0,0,0));
            wait(pixel_width*3);
            setLeds(ledHelper(1,1,1,1,1,1,1,1));
            wait(pixel_width);
            
            setLeds(ledHelper(0,0,0,0,0,0,0,0));
            wait(space_width);
            
            //E
            setLeds(ledHelper(1,1,1,1,1,1,1,1));
            wait(pixel_width);
            setLeds(ledHelper(1,1,0,1,1,0,1,1));
            wait(pixel_width*4);
            
            setLeds(ledHelper(0,0,0,0,0,0,0,0));
            wait(space_width);
            
            //L
            setLeds(ledHelper(1,1,1,1,1,1,1,1));
            wait(pixel_width);
            setLeds(ledHelper(1,1,0,0,0,0,0,0));
            wait(pixel_width*4);
            
            setLeds(ledHelper(0,0,0,0,0,0,0,0));
            wait(space_width);
            
            //L
            setLeds(ledHelper(1,1,1,1,1,1,1,1));
            wait(pixel_width);
            setLeds(ledHelper(1,1,0,0,0,0,0,0));
            wait(pixel_width*4);
            
            setLeds(ledHelper(0,0,0,0,0,0,0,0));
            wait(space_width);
            
            //O
            setLeds(ledHelper(1,1,1,1,1,1,1,1));
            wait(pixel_width);
            setLeds(ledHelper(1,1,0,0,0,0,1,1));
            wait(pixel_width*3);
            setLeds(ledHelper(1,1,1,1,1,1,1,1));
            wait(pixel_width);
            
            setLeds(ledHelper(0,0,0,0,0,0,0,0));
            
            int time = timer.read_ms();
            wait((rotation_time_ms - time) / 1000.);     
        }
        m3pi.stop();
    }
}
