#include <mbed.h>
#include <string>
#include <list>
#include <mpr121.h>

#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "uLCD_4DGL.h"
#include <iostream>
#include <fstream>
using namespace std;
 
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
AnalogOut DACout(p18);
wave_player waver(&DACout);
uLCD_4DGL uLCD(p28, p27, p30); // serial tx, serial rx, reset pin;
AnalogIn pot(p20);   // Potentiometer slider
Ticker timerz;
InterruptIn button(p12);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

float ain;
int kp;
bool lock = false;
int vol = 14;
bool playing = true;


// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p26);

void volumechange() {
    ain = pot.read();
    vol = ((floor(ain*100)) );
    }

// Setup the Serial to the PC for debugging
Serial pc(USBTX, USBRX);

// Setup the i2c bus on pins 28 and 27
I2C i2c(p9, p10);

// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);



void call_speaker_code(int key_code) {
    if (key_code != 0) {
        pc.printf("key code: %d\r\n", key_code);
        /////////////////////////////////////
        // Speaker/SD card code goes here...
        // ex. Play song 1
       
    }
}
void fallInterrupt() {
    int key_code=0;
    int i=0;
    int value=mpr121.read(0x00);
    
    if (lock == false) {
    value +=mpr121.read(0x01)<<8;
    // LED demo mod by J. Hamblen
    //pc.printf("MPR value: %x \r\n", value);
    i=0;
    // puts key number out to LEDs for demo
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
        }
    led4=key_code & 0x01;
    led3=(key_code>>1) & 0x01;
    led2=(key_code>>2) & 0x01;
    led1=(key_code>>3) & 0x01;
    call_speaker_code(key_code);
    kp = key_code;
    }
}
int main() {
    
    pc.printf("\nHello from the mbed & mpr121\n\r");

    unsigned char dataArray[2];
    int key;
    int count = 0;

    pc.printf("Test 1: read a value: \r\n");
    dataArray[0] = mpr121.read(AFE_CFG);
    pc.printf("Read value=%x\r\n\n",dataArray[0]);

    pc.printf("Test 2: read a value: \r\n");
    dataArray[0] = mpr121.read(0x5d);
    pc.printf("Read value=%x\r\n\n",dataArray[0]);

    pc.printf("Test 3: write & read a value: \r\n");
    mpr121.read(ELE0_T);
    mpr121.write(ELE0_T,0x22);
    dataArray[0] = mpr121.read(ELE0_T);
    pc.printf("Read value=%x\r\n\n",dataArray[0]);

    pc.printf("Test 4: Write many values: \r\n");
    unsigned char data[] = {0x1,0x3,0x5,0x9,0x15,0x25,0x41};
    mpr121.writeMany(0x42,data,7);

    // Now read them back ..
    key = 0x42;
    count = 0;
    while (count < 7) {
        char result = mpr121.read(key);
        key++;
        count++;
        pc.printf("Read value: '%x'=%x\n\r",key,result);
    }

    pc.printf("Test 5: Read Electrodes:\r\n");
    key = ELE0_T;
    count = 0;
    while (count < 24) {
        char result = mpr121.read(key);
        pc.printf("Read key:%x value:%x\n\r",key,result);
        key++;
        count++;
    }
    pc.printf("--------- \r\n\n");

    // mpr121.setProximityMode(true);

    pc.printf("ELE_CFG=%x", mpr121.read(ELE_CFG));

    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    
    timerz.attach(&volumechange, .25);
    ////////////////////////////////////
    while (1) {
    
     
     if(kp == 1){
        lock = true;
        uLCD.cls(); 
         uLCD.locate(0,0); 
    uLCD.printf("Movie Title: \nChristmas Vacation   \n");
    // Play MUSIC CHOICE
    FILE *wave_file;
    //printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/cv.wav", "r");
    waver.play(wave_file);
    fclose(wave_file);
    
   
    wait(1);
    kp = 0;
        lock = false;
    } 
        
    else if(kp == 2){
        lock = true;
        uLCD.cls(); 
         uLCD.locate(0,0); 
    uLCD.printf("Music Artist: \n Psy    \n\n Song Title: \n Gangnam Style \n");
    // Play MUSIC CHOICE
    FILE *wave_file;
    //printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/psy.wav", "r");
    waver.play(wave_file);
    fclose(wave_file);
    wait(1);
    kp = 0;
        lock = false;
    }     
    
    else if(kp == 3){
        lock = true;
        uLCD.cls(); 
        uLCD.locate(0,0); 
    uLCD.printf("Music Artist: \n Led Zeppelin    \n \n Song Title: \n Kashmir\n");
    // Play MUSIC CHOICE
    FILE *wave_file;
    //printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/led.wav", "r");
    waver.play(wave_file);
    fclose(wave_file);
    wait(1);
    kp = 0;
        lock = false;
    }     
        
    else if(kp == 4){
        lock = true;
        uLCD.cls(); 
        uLCD.locate(0,0); 
    uLCD.printf("Movie Title: \n Forrest Gump \n");
    // Play MUSIC CHOICE
    FILE *wave_file;
    //printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/boc.wav", "r");
    waver.play(wave_file);
    fclose(wave_file);
    wait(1);
    kp = 0;
        lock = false;
    }       
     
    else if(kp == 5){
        lock = true;
        uLCD.cls(); 
        uLCD.locate(0,0); 
    uLCD.printf("Movie Title: \n Forrest Gump \n \n");
    // Play MUSIC CHOICE
    FILE *wave_file;
    //printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/shrimp.wav", "r");
    waver.play(wave_file);
    fclose(wave_file);
    wait(1);
    kp = 0;
        lock = false;
    }  
     
    else if(kp == 6){
        lock = true;
        uLCD.cls(); 
        uLCD.locate(0,0); 
    uLCD.printf("Movie Title: \n TombStone \n \n I'm Your Huckleberry...");
    // Play MUSIC CHOICE
    FILE *wave_file;
    //printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/doc.wav", "r");
    waver.play(wave_file);
    fclose(wave_file);
    wait(1);
    kp = 0;
        lock = false;
    }  
    
    else if(kp == 7){
        lock = true;
        uLCD.cls(); 
        uLCD.locate(0,0); 
    uLCD.printf("Movie Title: \n Rush Hour \n");
    // Play MUSIC CHOICE
    FILE *wave_file;
    //printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/rushhour.wav", "r");
    waver.play(wave_file);
    fclose(wave_file);
    wait(1);
    kp = 0;
        lock = false;
    }  
    
    else if(kp == 8){
        lock = true;
        uLCD.cls(); 
        uLCD.locate(0,0); 
    uLCD.printf("Movie Title: \n Meet the Parents \n");
    // Play MUSIC CHOICE
    FILE *wave_file;
    //printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/meet.wav", "r");
    waver.play(wave_file);
    fclose(wave_file);
    wait(1);
    kp = 0;
        lock = false;
    } 
    
    else if(kp == 9){
        lock = true;
        uLCD.cls(); 
         uLCD.locate(0,0); 
    uLCD.printf("Music Artist: \n Glen Miller    \n \n Song Title: In the Mood \n");
    // Play MUSIC CHOICE
    FILE *wave_file;
    //printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/glenmiller.wav", "r");
    waver.play(wave_file);
    fclose(wave_file);
    wait(1);
    kp = 0;
        lock = false;
    } 
    
    else if(kp == 10){
        lock = true;
        uLCD.cls(); 
         uLCD.locate(0,0); 
    uLCD.printf("Music Artist: \n El dudio   \n \n Song Title: \n Guitarra de Noche\n");
    // Play MUSIC CHOICE
    FILE *wave_file;
    //printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/gut.wav", "r");
    waver.play(wave_file);
    fclose(wave_file);
    wait(1);
    kp = 0;
        lock = false;
    } 
    
    else if(kp == 11){
        lock = true;
        uLCD.cls(); 
         uLCD.locate(0,0); 
    uLCD.printf("Movie Title: \n The Lion King \n");
    // Play MUSIC CHOICE
    FILE *wave_file;
    //printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/lionking.wav", "r");
    waver.play(wave_file);
    fclose(wave_file);
    wait(1);
    kp = 0;
        lock = false;
    } 
   
   else if(kp == 12){
        lock = true;
        uLCD.cls(); 
         uLCD.locate(0,0); 
    uLCD.printf("Movie Title: \n Anchor Man \n");
    // Play MUSIC CHOICE
    FILE *wave_file;
    //printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/anchor.wav", "r");
    waver.play(wave_file);
    fclose(wave_file);
    wait(1);
    kp = 0;
        lock = false;
    }    
        
    }//ends while
}//ends main

