#include "wheelchair.h"

AnalogIn x(A0);
AnalogIn y(A1);

DigitalOut on(D12);
DigitalOut off(D11);
DigitalOut up(D2);
DigitalOut down(D3);

bool manual = false;
bool leftBound = false;
bool rightBound = false;
bool straightBound = false;

Serial pc(USBTX, USBRX, 9600);
Timer t;

Wheelchair smart(xDir,yDir, &pc, &t);


int main(void)
{
    smart.stop();
    while(1) {
                pc.printf("turning on joystick\n");
                manual = true;
                t.reset();
                while(manual) {
                    smart.move(x,y,leftBound,rightBound,straightBound);
                    if( pc.readable()) {
                        char d = pc.getc();
                        if( d == 'l') {
                            leftBound = true;
                        }

                        if (d == 'e') {
                            leftBound = false;
                        }

                        if( d == 'f') {
                            straightBound = true;
                        }

                        if (d == 'o') {
                            straightBound = false;
                        }

                        if( d == 'r') {
                            rightBound = true;
                        }

                        if( d == 'i') {
                            rightBound = false;
                        }

                        if( d == 'm') {
                            pc.printf("turning off joystick\n");
                            manual = false;
                        }
                    }
                }
            }

    wait(process);
}



