#include "wheelchair.h"

bool manual_drive = false;
volatile float north;
//volatile double curr_yaw;
double curr_yaw;
double Setpoint, Output;
PID myPID(&curr_yaw, &Output, &Setpoint, .1, .1, 5, DIRECT);

void Wheelchair::compass_thread() {
    
     //north = lowPass(imu->angle_north());
     //Input = (double)curr_yaw;
     curr_yaw = imu->yaw();
     north = boxcar(imu->angle_north());
    //out->printf("curr_yaw %f\n", curr_yaw);
     //out->printf("%f\n", curr_yaw);
     //out->printf("%f gyroz\n",imu->gyro_z());
     //out->printf("yaw is %f, north is %f, curr_yaw is %f\n", comp_yn, north, curr_yaw);
    
        //out->printf("Yaw is %f\n", imu->yaw());
        //out->printf("north is %f\n", imu->angle_north());
    
    }
    
Wheelchair::Wheelchair(PinName xPin, PinName yPin, Serial* pc, Timer* time )
{
    x = new PwmOut(xPin);
    y = new PwmOut(yPin);
    imu = new chair_BNO055(pc, time);
    //imu = new chair_MPU9250(pc, time);
    Wheelchair::stop();
    imu->setup();
    out = pc;
    out->printf("wheelchair setup done \n");
    ti = time;
    wheel = new QEI(Encoder1, Encoder2, NC, EncoderReadRate);
    myPID.SetMode(AUTOMATIC);
}

/*
* joystick has analog out of 200-700, scale values between 1.3 and 3.3
*/
void Wheelchair::move(float x_coor, float y_coor)
{

    float scaled_x = ((x_coor * 1.6f) + 1.7f)/3.3f;
    float scaled_y = (3.3f - (y_coor * 1.6f))/3.3f;
    
   // lowPass(scaled_x);
    //lowPass(scaled_y);
    
    x->write(scaled_x);
    y->write(scaled_y);
    
    //out->printf("yaw %f\n", imu->yaw());

}

void Wheelchair::forward()
{
    x->write(high);
    y->write(def+offset);
}

void Wheelchair::backward()
{
    x->write(low);
    y->write(def);
}

void Wheelchair::right()
{
    x->write(def);
    y->write(low);
}

void Wheelchair::left()
{
    x->write(def);
    y->write(high);
}

void Wheelchair::stop()
{
    x->write(def);
    y->write(def);
}
// counter clockwise is -
// clockwise is +
void Wheelchair::pid_right(int deg) 
{
    bool overturn = false;
    
    out->printf("pid right\n");
    x->write(def);
    Setpoint = curr_yaw + deg;
    
    if(Setpoint > 360) {
        Setpoint -= 360;
        overturn = true;
    }
    
    myPID.SetOutputLimits(low, def);
    myPID.SetControllerDirection(REVERSE);
    out->printf("setpoint %f curr_yaw %f input %f output %i  %i same address\n", Setpoint, curr_yaw, *(myPID.myInput), *(myPID.myOutput), (myPID.myInput==&curr_yaw), (myPID.myOutput == &Output) );
    out->printf("addresses %i %i\n", myPID.myInput, &curr_yaw);
    while(myPID.Compute()) {
        y->write(Output);
        out->printf("curr_yaw %f\n", curr_yaw);
        }
    Wheelchair::stop();
    out->printf("done \n");
    }

void Wheelchair::pid_left(int deg) 
{
    bool overturn = false;
    
    x->write(def);
    Setpoint = curr_yaw - deg;
    
    if(Setpoint < 0) {
        Setpoint += 360;
        overturn = true;
    }
    myPID.SetOutputLimits(def,high);
    myPID.SetControllerDirection(DIRECT);
    while(myPID.Compute()) {
        y->write(Output);
        out->printf("curr_yaw %f\n", curr_yaw);
        }
    Wheelchair::stop();
    }

void Wheelchair::pid_turn(int deg) {
    if(deg > 180) {
        deg -= 360;
    }

    else if(deg < -180) {
        deg+=360;
    }  
    
    int turnAmt = abs(deg);
    ti->reset();

    if(deg >= 0){
        Wheelchair::pid_right(turnAmt);
        }
    else {
        Wheelchair::pid_left(turnAmt);
        }
    }
    
double Wheelchair::turn_right(int deg)
{
    bool overturn = false;
    out->printf("turning right\n");

    double start = curr_yaw;
    double final = start + deg;

    if(final > 360) {
        final -= 360;
        overturn = true;
    }

    out->printf("start %f, final %f\n", start, final);

    double curr = -1;
    while(curr <= final - 30) {
        Wheelchair::right();
        if( out->readable()) {
            out->printf("stopped\n");
            Wheelchair::stop();
            return;
        }
        curr = curr_yaw;
        if(overturn && curr > (360 - deg) ) {
            curr = 0;
        }
    }
    
    out->printf("done turning start %f final %f\n", start, final);
    Wheelchair::stop();
    
     //delete me
    wait(5);
    
    float correction = final - curr_yaw;
    out->printf("final pos %f actual pos %f\n", final, curr_yaw);
    Wheelchair::turn_left(abs(correction));
    Wheelchair::stop();
    
    wait(5);
    out->printf("curr_yaw %f\n", curr_yaw);
    return final;
}

double Wheelchair::turn_left(int deg)
{
    bool overturn = false;
    out->printf("turning left\n");

    double start = curr_yaw;
    double final = start - deg;

    if(final < 0) {
        final += 360;
        overturn = true;
    }

    out->printf("start %f, final %f\n", start, final);

    double curr = 361;
    while(curr >= final) {
        Wheelchair::left();
        if( out->readable()) {
            out->printf("stopped\n");
            Wheelchair::stop();
            return;
        }
        curr = curr_yaw;

        if(overturn && curr >= 0 && curr <= start ) {
            curr = 361;
        }
    }

    out->printf("done turning start %f final %f\n", start, final);
    Wheelchair::stop();
    
    //delete me
    wait(2);
    /*
    float correction = final - curr_yaw;
    out->printf("final pos %f actual pos %f\n", final, curr_yaw);
    Wheelchair::turn_right(abs(correction));
    Wheelchair::stop();
*/
    return final;
}

void Wheelchair::turn(int deg)
{
    if(deg > 180) {
        deg -= 360;
    }

    else if(deg < -180) {
        deg+=360;
    }  
    
    double finalpos;
    int turnAmt = abs(deg);
    //ti->reset();
    /*
    if(deg >= 0){
        finalpos = Wheelchair::turn_right(turnAmt);
        }
    else {
        finalpos = Wheelchair::turn_left(turnAmt);
        }
    */
    wait(2);
    
    float correction = finalpos - curr_yaw;
    out->printf("final pos %f actual pos %f\n", finalpos, curr_yaw);
    
    
    //if(abs(correction) > turn_precision) {
        out->printf("correcting %f\n", correction);
        //ti->reset();
        Wheelchair::turn_left(curr_yaw - finalpos);
        return;
        //} 
    
}

float Wheelchair::getDistance() {
    return wheel->getDistance(Diameter);
    }
    
void Wheelchair::resetDistance(){
    wheel->reset();
    }


