#ifndef wheelchair
#define wheelchair

#include "chair_BNO055.h"
#include "PID_v1.h"
#include "QEI.h"
#include <ros.h>
#include <geometry_msgs/Twist.h>

//#include "chair_MPU9250.h"

#define turn_precision 10
#define def (2.5f/3.3f)
#define high 3.3f/3.3f
#define offset .02f
#define low (1.7f/3.3f)
#define process .1

/* for big mbed board
#define xDir D12 //top right two pins
#define yDir D13 //top left two pins
#define Encoder1 D0
#define Encoder2 D1
*/

//for small mbed board
#define xDir D9
#define yDir D10
#define Encoder1 D7
#define Encoder2 D8

#define EncoderReadRate 1200
#define Diameter 31.75
/** Wheelchair class
 * Used for controlling the smart wheelchair
 */
class Wheelchair
{
public:
    /** Create Wheelchair Object with x,y pin for analog dc output
     * serial for printout, and timer
     */
    Wheelchair(PinName xPin, PinName yPin, Serial* pc, Timer* time);
    
    /** move using the joystick */
    void move(float x_coor, float y_coor);
    
    /* turn right a certain amount of degrees (overshoots)*/
    double turn_right(int deg);
    
    /* turn left a certain amount of degrees (overshoots)*/
    double turn_left(int deg);
    
    /* turn right a certain amount of degrees using PID*/
    void pid_right(int deg);
    
    /* turn left a certain amount of degrees using PID*/
    void pid_left(int deg);
    
    /* turning function that turns any direction */
    void turn(int deg);
    
    /* drive the wheelchair forward */
    void forward();
    
    /* drive the wheelchair backward*/
    void backward();
    
    /* turn the wheelchair right*/
    void right();
    
    /* turn the wheelchair left*/
    void left();
    
    /* stop the wheelchair*/
    void stop();
    
    /* function to get imu data*/
    void compass_thread();
    float getDistance();
    void resetDistance();
    void pid_turn(int deg);
    
private:
    PwmOut* x;
    PwmOut* y;
    chair_BNO055* imu;
    Serial* out;
    Timer* ti;
    QEI* wheel;

};
#endif