#ifndef wheelchair
#define wheelchair
#include "mbed.h"

#define turn_precision 10
#define def (2.5f/3.3f)
#define high 3.3f
#define offset .02f
#define low (1.7f/3.3f)
#define process .1
#define xDir D9
#define yDir D10

class Wheelchair
{
public:
    Wheelchair(PinName xPin, PinName yPin, Serial* pc, Timer* time);
    void move(float x_coor, float y_coor);
    double turn_right(int deg);
    double turn_left(int deg);
    void turn(int deg);
    void forward();
    void backward();
    void right();
    void left();
    void stop();
    void compass_thread();

private:
    PwmOut* x;
    PwmOut* y;
    Serial* out;
    Timer* ti;

};
#endif