#include "wheelchair.h"

AnalogIn x(A0);
AnalogIn y(A1);

DigitalOut on(D12);
DigitalOut off(D11);
DigitalOut up(D2);
DigitalOut down(D3);

bool manual = false;

Serial pc(USBTX, USBRX, 9600);
Timer t;

Wheelchair smart(xDir,yDir, &pc, &t);

char c = 'z';

int main(void)
{
    while(1) {
        if( pc.readable()) {
            c = pc.getc();
        }

        else {
            if( c == 'w') {
                pc.printf("up \n");
                smart.forward();
            }

            else if( c == 'a') {
                pc.printf("left \n");
                smart.left();
            }

            else if( c == 'd') {
                pc.printf("right \n");
                smart.right();
            }

            else if( c == 's') {
                pc.printf("down \n");
                smart.backward();
            }

            else if( c == 'r') {
                smart.turn_right(90);
            }

            else if( c == 'l') {
                smart.turn_left(90);
            }
             else if(c == 'o') {
                pc.printf("turning on\n");
                on = 1;
                wait(1);
                on = 0;
                c = 'z';
            } else if(c == 'f') {
                pc.printf("turning off\n");
                off = 1;
                wait(1);
                off = 0;
                c = 'z';
            }

            else if( c == 't') {
                char buffer[256];
                pc.printf ("Enter a long number: ");
                fgets (buffer, 256, stdin);
                int angle = atoi (buffer);

                if(angle == 0) {
                    pc.printf("invalid input try again\n");
                } else {
                    smart.turn(angle);
                }

            }

            else if( c == 'm') {
                pc.printf("turning on joystick\n");
                manual = true;
                t.reset();
                while(manual) {
                    smart.move(x,y);
                    if( pc.readable()) {
                        char d = pc.getc();
                        if( d == 'm') {
                            pc.printf("turning off joystick\n");
                            manual = false;
                        }
                    }
                }
            }

            else {
                smart.stop();
                pc.printf("hello\n");
            }
        }
    }
    wait(process);
}



