/*! \file main.cpp
 *  \brief ADC fucntionality
 *  Holds the ADC functionality.  Demonstration code was used.
 *  http://www.keil.com/forum/22348/frdm-kl25z/
 */

#include "mbed.h"

// Comment out to use polling loop
#define INTERRUPT

// LEDS
DigitalOut led1(LED1);
DigitalOut led2(PB_10);

/*! \brief Interrupt service routine for button 1 sets led 1 on
 */
void button1_ISR()
{
  __disable_irq();
  led1 = 1;
  __enable_irq();
}

/*! \brief Interrupt service routine for button 2 sets led 1 on
 */
void button2_ISR()
{
  __disable_irq();
  led1 = 0;
  __enable_irq();
}

/*! \brief Interrupt service routine for button 3 sets led 2 on
 */
void button3_ISR()
{
  __disable_irq();
  led2 = 1;
  __enable_irq();
}

/*! \brief Interrupt service routine for button 4 sets led 2 off
 */
void button4_ISR()
{
  __disable_irq();
  led2 = 0;
  __enable_irq();
}

/*! \brief Main function either sets up ISRs or runs a polling loop
 */
int main() {
#ifdef INTTERUPT
  // Initialize the interrupts
  InterruptIn b1(PA_10);
  InterruptIn b2(PB_3);
  InterruptIn b3(PB_5);
  InterruptIn b4(PB_4);

  // Set the ISR for the interrupt
  b1.rise(&button1_ISR);
  b2.rise(&button2_ISR);
  b3.rise(&button3_ISR);
  b4.rise(&button4_ISR);

  // Loop forever putting the device to sleep to wait for an interrupt
  while (1)
  {
    __WFI();
  }

#else

  static bool led1_on = false;
  static bool led2_on = false;
  BusIn buttons(PA_10, PB_3, PB_5, PB_4);

  while(1)
  {
    volatile int gpio = buttons.read();
    // LED 1 on
    if ((gpio & 0x01) == 0)
    {
      led1_on = true;
    }

    // LED 1 off
    if ((gpio & 0x02) == 0)
    {
      led1_on = false;
    }

    // LED 2 on
    if ((gpio & 0x04) == 0)
    {
      led2_on = true;
    }

    // LED 2 off
    if ((gpio & 0x08) == 0)
    {
      led2_on = false;
    }

    led1 = led1_on;
    led2 = led2_on;
  }
#endif // INTERRUPT
}

