#ifndef STATECHART_H
#define STATECHART_H

#define MINBRITE    (0.2)
#define MAXBRITE    (0.5)
#define PI          (3.141592653589793)

class Statechart{
public:
    enum actState_t {
        REST,
        LOOK_LEFT,
        LOOK_RIGHT,
        FLOP,
        WALK,
        FLAP,
        BATTERY_LOW
    };
    
    enum emoState_t {
        CURIOUS,
        MAD,
        HAPPY,
        SAD
    };
    
    void fishStatechart(int netTime, int capNum, int prox, float* xyz, Serial &maestro, WS2811 &lightStrip1, WS2811 &lightStrip2, float battery);
    
private:
    void showRainbow(WS2811 &strip, float sat, float brite, float hueShift);
    void showSolidColor(WS2811 &strip, uint8_t r, uint8_t g, uint8_t b);
    void showSolidColorBright(WS2811 &strip, uint8_t r, uint8_t g, uint8_t b, float newBrite);
    void showSomeRainbow(WS2811 &strip, float hueLow, float hueHigh, float sat, float brite);
    void setMaestroSubroutine(Serial &maestro,  int subNum, int parameter, bool withParameter);
    void setServoValue(Serial &maestro, int index, uint16_t x0, uint16_t x1, uint16_t x2);
};

#endif
