#include "mbed.h"
#include "tsi_sensor.h"
#include "TextLCD.h"
#define ELEC0 9 // Constant for KL25Z tsi
#define ELEC1 10 // Constant for KL25Z tsi
TextLCD lcd(D2, D3, D4, D5, D6, D7); // Initlize LCD PIN => RS, EN, Data4, Data5, Data6, Data7
PwmOut led(LED_GREEN); // Initlize Green LED Pin as PWM Output
TSIAnalogSlider tsi(ELEC0, ELEC1, 40); // Initlize tsi Slider

int main(void) {
    
    lcd.cls(); // Clear LCD
    lcd.locate(0,0); // cursor on Col=0, Raw=0
    lcd.printf("Experiment - 9"); // print startup message on LCD first Raw
    lcd.locate(0,1); // cursor on Col=0, Raw=1
    lcd.printf("TSI LCD & PWM"); // print startup message on LCD second Raw
    wait(3.0); // wait 3 second to show startup message
    while (true) {
        float slider_pos,f;
        slider_pos = tsi.readPercentage(); // Read TSI Slider Position i.e 0.00 to 1.00
        led = 1.0f - slider_pos; // Update PWN on LED
        lcd.cls(); // Clear LCD
        lcd.locate(0,0); // cursor on Col=0, Raw=0
        lcd.printf("TSI Value = %0.2f",tsi.readPercentage()); //Print Slider TSI Value on LCD first line
        lcd.locate(0,1); // cursor on Col=0, Raw=1
        for(f=0.000f;f<slider_pos;f=f+0.063f) // Loop draw H-Bar on Second line of LCD
        {
            lcd.printf("#");
        }
        wait(0.1);
    }
}
