#include "mbed.h"
#include "MMA8451Q.h"
#include "TextLCD.h"
#define MMA8451_I2C_ADDRESS (0x1d<<1)

TextLCD lcd(D2, D3, D4, D5, D6, D7); // LCD PIN => RS, EN, Data4, Data5, Data6, Data7

PinName const SDA = PTE25; //I2C Pins for KL25Z
PinName const SCL = PTE24; //I2C Pins for KL25Z

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS); //Initilize MMA8451Q Accelerometer 

int main(void)
{
    lcd.cls(); // Clear LCD
    lcd.locate(0,0); // cursor on Col=0, Raw=0
    lcd.printf("Experiment - 8"); // print startup message on LCD first Raw
    lcd.locate(0,1); // cursor on Col=0, Raw=1
    lcd.printf("MMA8451 With LCD"); // print startup message on LCD second Raw
    wait(3.0); // wait 3 second to show startup message
    while (1) 
    {
        float x, y, z;
        x = acc.getAccX(); // get Acceleration on X
        y = acc.getAccY(); // get Acceleration on Y
        z = acc.getAccZ(); // get Acceleration on Z
        lcd.cls(); // Clear LCD
        lcd.locate(0,0); // cursor on Col=0, Raw=0
        lcd.printf("X:%0.2f",x); // print value of X in first line of LCD
        lcd.locate(8,0); // cursor on Col=8, Raw=0
        lcd.printf("Y:%0.2f",y); // print value of Y in first line of LCD
        lcd.locate(4,1); // cursor on Col=5, Raw=1
        lcd.printf("Z:%0.2f",z); // print value of Z in first line of LCD
        wait(0.1); // Wait for 100ms to visulize reading on LCD
        
    }
}
