#include "mbed.h"
#include "MMA8451Q.h"
#define MMA8451_I2C_ADDRESS (0x1d<<1)

Serial pc(USBTX, USBRX); // Initlize UART on USB port of KL25Z with default Baud 9600

PinName const SDA = PTE25; //I2C Pins for KL25Z
PinName const SCL = PTE24; //I2C Pins for KL25Z

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS); //Initilize MMA8451Q Accelerometer 

int main(void)
{
    // pc.baud(115200); // uncomment this line and update baudrate to cahnge baud rate from 9600 default
    
    pc.printf("\r\n"); // print startup message from new line on UART Terminal
    pc.printf("Experiment - 7\r\n"); // print startup message on UART Terminal
    pc.printf("MMA8451 Interfacing With UART"); // print startup message from new line on UART Terminal
    pc.printf("\r\n"); // print startup message from new line on UART Terminal
    wait(2.0);
    while (1) {
        float x, y, z;
        x = acc.getAccX(); // get Acceleration on X
        y = acc.getAccY(); // get Acceleration on Y
        z = acc.getAccZ(); // get Acceleration on Z
        wait(0.1);
        pc.printf("X: %0.2f, \tY: %0.2f, \tZ: %0.2f\n", x, y, z); //Print X,Y,Z Acceleration on UART Terminal
    }
}
