#include "mbed.h"
DigitalOut myledr(LED_RED); // initlize RED LED pin as OUTPUT
DigitalOut myledg(LED_GREEN); // initlize GREEN LED pin as OUTPUT
DigitalOut myledb(LED_BLUE); // initlize BLUE LED pin as OUTPUT
Serial pc(USBTX, USBRX); // Initlize UART on USB port of KL25Z with default Baud 9600

void showhelp()
{
    pc.printf("\r\n"); // print Command list from new line on UART Terminal
    pc.printf("**** Command List ****\r\n"); // print Command list on UART Terminal
    pc.printf("h -> Help\r\n"); 
    pc.printf("r -> Turn on RED LED\r\n"); 
    pc.printf("R -> Turn off  RED LED\r\n"); 
    pc.printf("g -> Turn on GREEN LED\r\n");
    pc.printf("G -> Turn off  GREEN LED\r\n"); 
    pc.printf("b -> Turn on BLUE LED\r\n");
    pc.printf("B -> Turn off  BLUE LED\r\n"); 
}
    
int main()
{
    char rxbyte;
    // pc.baud(115200); // uncomment this line and update baudrate to cahnge baud rate from 9600 default
    myledr = 1; // Turn Off RED LED
    myledg = 1; // Turn Off GREEN LED
    myledb = 1; // Turn Off BLUE LED
    pc.printf("\r\n"); // print startup message from new line on UART Terminal
    pc.printf("Experiment - 6\r\n"); // print startup message on UART Terminal
    pc.printf("UART Interfacing TX RX \r\n"); // print startup message on UART Terminal
    pc.printf("\r\n"); // print startup message from new line on UART Terminal
    showhelp();
    wait(3.0); // wait 3 second to show startup message
    while (true) 
    {
        wait(0.5f); // wait a small period of time
        if (pc.readable()) 
        {                                // If pc is readable
            rxbyte = pc.getc();
            if(rxbyte == 'r') {pc.printf("RED LED ON\r\n"); myledr = 0;}
            else if(rxbyte == 'R') {pc.printf("RED LED OFF\r\n"); myledr = 1;}
            else if(rxbyte == 'g') {pc.printf("RED LED ON\r\n"); myledg = 0;}
            else if(rxbyte == 'G') {pc.printf("RED LED OFF\r\n"); myledg = 1;}
            else if(rxbyte == 'b') {pc.printf("RED LED ON\r\n"); myledb = 0;}
            else if(rxbyte == 'B') {pc.printf("RED LED OFF\r\n"); myledb = 1;}
            else if(rxbyte == 'h') {showhelp();}
            else  {pc.printf("Error: Invalid command type 'h' for help...\r\n"); }
            rxbyte = 0x00;
        }
        
    }
}

