#include "mbed.h"
Serial pc(USBTX, USBRX); // Initlize UART on USB port of KL25Z with default Baud 9600
AnalogOut aout(PTE30); // The waveform is created on this pin
void showhelp()
{
    pc.printf("\r\n"); // print Command list from new line on UART Terminal
    pc.printf("**** Command List ****\r\n"); // print Command list on UART Terminal
    pc.printf("h -> Help\r\n");
    pc.printf("s -> Generate Sine wave\r\n");
    pc.printf("t -> Generate Triangular Wave\r\n");
    pc.printf("i -> Increase Amplitude\r\n");
    pc.printf("d -> Decrease Amplitude\r\n");

}
int main()
{
    const double pi = 3.14;
    const double offset = 65535/2;
    double rads = 0.0;
    uint16_t sample = 0;
    float amplitude = 0.0f;
    char rxbyte;
    int wavetype = 0;
    // pc.baud(115200); // uncomment this line and update baudrate to cahnge baud rate from 9600 default
    pc.printf("\r\n"); // print startup message from new line on UART Terminal
    pc.printf("Experiment - 13\r\n"); // print startup message on UART Terminal
    pc.printf("DAC Waveform Generator\r\n"); // print startup message on UART Terminal
    showhelp();
    wait(3.0); // wait 3 second to show startup message
    while(1) {
        if (pc.readable()) { // If pc is readable
            rxbyte = pc.getc();
            if(rxbyte == 's') {
                pc.printf("SINE WAVE\r\n");
                wavetype = 0;
            } else if(rxbyte == 't') {
                pc.printf("TRIANGULAR WAVE\r\n");
                wavetype = 1;
            } else if(rxbyte == 'i') {
                pc.printf("AMPLITUDE INCREASED\r\n");
                amplitude+=0.1f;
            } else if(rxbyte == 'd') {
                pc.printf("AMPLITUDE INCREASED\r\n");
                amplitude-=0.1f;
            } else if(rxbyte == 'h') {
                showhelp();
            } else  {
                pc.printf("Error: Invalid command type 'h' for help...\r\n");
            }
            rxbyte = 0x00;
            if(amplitude>1.0f) {
                amplitude = 1.0f;
                pc.printf("Amplitude Max limit reached...\r\n");
            } else if(amplitude<0.0f) {
                amplitude = 0.0f;
                pc.printf("Amplitude Min limit reached...\r\n");
            }
        }

        if(wavetype == 0) {
            // sinewave output
            for (int i = 0; i < 360; i++) {
                rads = (pi * i) / 180.0f;
                sample = (uint16_t)(amplitude * (offset * (cos(rads + pi))) + offset);
                aout.write_u16(sample);
            }
        }

        if(wavetype == 1) {
            // triwave output
            for (float i = 0.5f - (amplitude/2); i < 0.5f + (amplitude/2); i += 0.01f) {
                aout = i;
                wait(0.0003f);
            }
            for (float i = 0.5f + (amplitude/2); i > 0.5f - (amplitude/2); i -= 0.01f) {
                aout = i;
                wait(0.0003f);
            }
        }
    }
}