#include "mbed.h"
#include "Servo.h"
#include "tsi_sensor.h"
#include "TextLCD.h"
#define ELEC0 9 // Constant for KL25Z tsi
#define ELEC1 10 // Constant for KL25Z tsi
TextLCD lcd(D2, D3, D4, D5, D6, D7); // Initlize LCD PIN => RS, EN, Data4, Data5, Data6, Data7
TSIAnalogSlider tsi(ELEC0, ELEC1, 40); // Initlize tsi Slider  
Servo myservo(D8); // Initlize Servo motor
  
int main() {
      myservo.calibrate(0.001, 90.0); //caliberate servo for -90 to +90 (0-180) degree
      lcd.cls(); // Clear LCD
      lcd.locate(0,0); // cursor on Col=0, Raw=0
      lcd.printf("Experiment - 11"); // print startup message on LCD first Raw
      lcd.locate(0,1); // cursor on Col=0, Raw=1
      lcd.printf("TSI LCD+SERVO"); // print startup message on LCD second Raw
      wait(3.0); // wait 3 second to show startup message
      while(1) 
      {
          float slider_pos;
          slider_pos = tsi.readPercentage(); // Read TSI Slider Position i.e 0.00 to 1.00
          myservo.write(slider_pos); // Write to servo as percentage
          lcd.cls(); // Clear LCD
          lcd.locate(0,0); // cursor on Col=0, Raw=0
          lcd.printf("Slider = %0.2f",slider_pos); //Print Slider TSI Value on LCD first line
          lcd.locate(0,1); // cursor on Col=0, Raw=1
          lcd.printf("Servo  = %0.2f",slider_pos*180.0); //Print Servo angle Value on LCD Second line
          wait(0.01);
          
      }
  }
