
#include "mbed.h"
#include "Dht11.h"
#include "TextLCD.h"

TextLCD lcd(D2, D3, D4, D5, D6, D7); // Initlize LCD PIN => RS, EN, Data4, Data5, Data6, Data7
Dht11 mydht11(D9);
int main(void) {
    
    lcd.cls(); // Clear LCD
    lcd.locate(0,0); // cursor on Col=0, Raw=0
    lcd.printf("Experiment - 10"); // print startup message on LCD first Raw
    lcd.locate(0,1); // cursor on Col=0, Raw=1
    lcd.printf("DHT11 with LCD"); // print startup message on LCD second Raw
    wait(3.0); // wait 3 second to show startup message
    while (true) {
        float t,h;
        mydht11.read(); // Read DHT11 sensor
        t = mydht11.getCelsius(); // get Temperature in C
        h = mydht11.getHumidity(); // get Humidity in %
        lcd.cls(); // Clear LCD
        lcd.locate(0,0); // cursor on Col=0, Raw=0
        lcd.printf("Temp = %0.2f C",t); //Print Temperature Value on LCD first line
        lcd.locate(0,1); // cursor on Col=0, Raw=1
        lcd.printf("Humd = %0.2f %%",h); //Print Humidity Value on LCD Second line
        wait(1.0);
    }
}
