#include "mbed.h"
#include "ultrasonic.h"

DigitalOut RED(LED1);
DigitalOut GREEN(LED2);
DigitalOut BLUE(LED3);

void dist1(int distance1_mm)

{
    RED=1;
    GREEN=1;
    BLUE=1;
    //put code here to happen when the distance is changed
    int dis1_cm;
    dis1_cm=distance1_mm/10;
    printf("Distance of left sensor is %dcm\r\n", dis1_cm);
    if (dis1_cm<100) {
        RED=0;
    } else (RED=1);
}
void dist2(int distance2_mm)
{
    RED=1;
    GREEN=1;
    BLUE=1;
    int dis2_cm;
    dis2_cm=distance2_mm/10;
    printf("Distance of right sensor is %dcm\r\n", dis2_cm);
    if (dis2_cm<100) {
        GREEN=0;
    } else (GREEN=1);
}
ultrasonic mu1(D8, D9, .1, 1, &dist1);    //Set the trigger pin to D8 and the echo pin to D9
ultrasonic mu2(D6, D7, .1, 1, &dist2);    //have updates every .1 seconds and a timeout after 1
//second, and call dist when the distance changes

int main()
{
    mu1.startUpdates(); //start mesuring the distance for each sensor
    mu2.startUpdates();

    while(1) {

        mu1.checkDistance();  //call checkDistance() as much as possible, as this is where
        mu2.checkDistance();  //the class checks if dist needs to be called.
    }
}

