#pragma once
#include "globals.h"

const float g_KPX = 0.01;
const float g_KDX = 0.03;
const float g_KPW = 0.1;
const float g_KDW = 0.1;

const float g_MAX_SPEED = 0.3;
const float g_MIN_SPEED = 0.08;
const float g_DONE_THRESHOLD = 100;

class PIDController {
 public:
  PIDController();

  void reset();
  void update();

  void set_goal_x(int counts);
  void set_goal_w(int counts);

  bool is_done() const;
  char* get_data();

 private:
  void get_sensor_feedback();
  void x_controller();
  void w_controller();
  void update_motor_pwm();
  float limit_pwm(float pwm) const;

  int goal_x_;
  int goal_w_;

  float counts_x_;
  float counts_w_;

  float error_x_;
  float error_w_;

  float error_prev_x_;
  float error_prev_w_;

  float pwm_x_;
  float pwm_w_;

  int stop_cnt_;

  char data_buf_[200];
};

