#include "SimpleButtonDecoder.h"


SimpleButtonDecoder::SimpleButtonDecoder(AnalogInFiltered *analogIn, int value, short deBounceRuns)
{
    _analogIn = analogIn;
    _value = value;
    _isChanged = false;
    _deBounceRuns = deBounceRuns;
    _debounceCount = 1;

    _pulseUp=false;
    _status=false;
}

SimpleButtonDecoder::~SimpleButtonDecoder()
{
}

void SimpleButtonDecoder::process()
{
    _pulseUp=false;
    _pulseDown=false;

    // Detect if the analog in is within the value range + fuzzy factor
    if (abs((_analogIn->getData() + 32768) - _value) < _analogIn->getFuzzyFactor()) {
        // When the analog values iw within the fuzzy factor for XX debounce runs, consider this now a up flank to true state
        if (_debounceCount == _deBounceRuns) {
            _pulseUp=!_status;
            _status=true;
            _debounceCount++;
            return;
        }
        // If the _debounceCount is bigger then deboucneruns, consider this a on state (passed the up flanc)
        if (_debounceCount > _deBounceRuns) {
            return;
        }
        _debounceCount++;
    } else {
        // If debounce count is at 1, then consider this a down flanc back to false
        if (_debounceCount == 1) { 
            _debounceCount--;
            _pulseDown=_status;
            _status=false;
            return;
        }
        // if the debounce is below <1 then we have a stable state again.
        if (_debounceCount < 1) {
            return;
        }
        _debounceCount--;
    }
}

bool SimpleButtonDecoder::getStatus()
{
    return _status;
}

bool SimpleButtonDecoder::getIsChanged()
{
    return _pulseUp || _pulseDown;
}

bool SimpleButtonDecoder::getIsPressed()
{
    return _pulseUp;
}

bool SimpleButtonDecoder::getIsReleased()
{
    return _pulseUp;
}