#include "Button.h"


Button::Button(PinName pin, bool reversed, bool pullUp) : _digitalIn(new DigitalIn(pin)), _value(false), _reversed(reversed)
{
    _digitalIn->mode(pullUp?PullUp:PullDown);
    _lastValue=_digitalIn;
}

Button::~Button()
{
    delete(_digitalIn);
}

void Button::measure ()
{
    _value = _digitalIn->read() ^_reversed;
}

bool Button::getData() const
{
    return _value;
}

bool Button::getIsChanged()
{
    const bool lv = _lastValue;
    _lastValue = _value;
    return _value ^ lv;
}
