#ifndef SIMPLEBUTTONDECODER_H
#define SIMPLEBUTTONDECODER_H

#include "mbed.h"
#include "AnalogInFiltered.h"

/**
ButtonDecoder.
I was planning to make a r2R ladder network but I couldn't find any very accurate resitors here in Ecuador (no Señor, no tengo ... sigh)
so I bought some 5% resitors but they didn'0t work well enough. So this decoder sinply decoder the end value and this
it means only one button at a timn can be detected reliable.
*/
class SimpleButtonDecoder {
    private:
        AnalogInFiltered   *_analogIn;
        int _value;
        int _fuzzyFactor;
        bool _isChanged;
        short _deBounceRuns;
        short _debounceCount;
        
        bool _pulseUp;
        bool _pulseDown;
        bool _status;
    public:   
        /**
        filter : Failter chain
        pin : Analog input to read
        */
        SimpleButtonDecoder(AnalogInFiltered *_analogIn, int value, short deBounceRuns);
        ~SimpleButtonDecoder();
        
        // Process the buttons status information
        // Call this function for the button to updates it's state
        void process();
        
        // Returns the current button status
        // This state will be updated after each 'process' call
        bool getStatus();
        
        // Test if the input value is changed based on a offset
        // This state will be updated after each 'process' call
        bool getIsChanged();
        
        // Return's TRUE if the button was pressed
        // This state will be updated after each 'process' call
        bool getIsPressed();
        
        // Returns TRUE if the button was just released, 
        // This state will be updated after each 'process' call
        bool getIsReleased();

};

#endif