#ifndef LOWPASSFILTER_H
#define LOWPASSFILTER_H
#include "mbed.h"
#include "AnalogFilterInterface.h"

/**
* A simple First Order Low Pass filter for analog input's
* This is a IIR filter based on http://en.wikipedia.org/wiki/Iir_filter
*/
class LowPassFilter : public AnalogFilterInterface  {
    private:
        double _alpha;
        double smoothedValue;
    public:   
        /*
            chain : a interface to AnalogFilterInterface in case you want to chain several filters
            alpha : Filter coefficient. The lower the value of alpha, the less filtering is done
        */
        LowPassFilter(AnalogFilterInterface *chain, double alpha);
        ~LowPassFilter();
        virtual void setData(long data);
        virtual long getData() const;
};

#endif