#include "AutoScale.h"
#include <algorithm> 

AutoScale::AutoScale(AnalogFilterInterface *chain,long expectedMin, long expectedMax) :
    AnalogFilterInterface(chain), _expectedMax(expectedMax), _expectedMin(expectedMin), _currentMax(expectedMin), _currentMin(expectedMax), _current(0), _a(0.), _b(0), _mul(1.0)
{
}
AutoScale::AutoScale(AnalogFilterInterface *chain,long expectedMin, long expectedMax, double multiplier) :
    AnalogFilterInterface(chain), _expectedMax(expectedMax), _expectedMin(expectedMin), _currentMax(expectedMin), _currentMin(expectedMax), _current(0), _a(0.), _b(0), _mul(multiplier)
{
}

AutoScale::~AutoScale()
{
}

void AutoScale::setData(long dataPoint)
{
    getChain()->setData(dataPoint);
    _current = getChain()->getData();

    if (_current < _currentMin) {
        _currentMin = _current;
        reCalc();
    }
    if (_current > _currentMax) {
        _currentMax = _current;
        reCalc();
    }
    _current = (long)((_a * _current + _b)*_mul);

    _current = std::min(_current, _expectedMax);
    _current = std::max(_current, _expectedMin);
}

long AutoScale::getData() const
{
    return _current;
}

void AutoScale::reCalc()
{
    _a = (_expectedMax - _expectedMin) / (double)(_currentMax - _currentMin);
    _b = -((_a * _currentMax) - _expectedMax);
}

