#include "AnalogInFiltered.h"


AnalogInFiltered::AnalogInFiltered(AnalogFilterInterface *filter, PinName pin, int fuzzyFactor) : _ain(new AnalogIn(pin)), _fuzzyFactor(fuzzyFactor), _filter(filter), _lastValue(0) {
}

AnalogInFiltered::~AnalogInFiltered() {
    delete(_ain);
}

void AnalogInFiltered::setData (long d) {
    _filter->setData(_ain->read_u16() - 32768);
}

long AnalogInFiltered::getData() const {
    return _filter->getData();
}


bool AnalogInFiltered::getIsChanged() {
//    _filter->setData(_ain->read_u16() - 32768);
    if (abs(_filter->getData() - _lastValue) > _fuzzyFactor) {
        _lastValue = _filter->getData();
        return true;
    }
    return false;
}

int AnalogInFiltered::getFuzzyFactor() {
    return _fuzzyFactor;
}
