#ifndef ANALOGFILTERINTERFACE_H
#define ANALOGFILTERINTERFACE_H

/**
    Analog filter Interface 
    This is the base class if you want to create your own filters and beable to chain them within analog inputs.
*/
class AnalogFilterInterface
{
    private:
        AnalogFilterInterface *_chain;
        long _data;
    public:
        AnalogFilterInterface(AnalogFilterInterface *chain);
        AnalogFilterInterface();
    
        // Set a datapoint
        virtual void setData(long data);

        // Get the filtered datapoint
        virtual long getData() const;
        
        // Get the chained filter
        virtual AnalogFilterInterface * getChain(){return _chain;};
};

#endif


                                               