#include "LowPassFilter.h"

LowPassFilter::LowPassFilter(AnalogFilterInterface *chain,double alpha) :  AnalogFilterInterface(chain) {
        _alpha = alpha;
        smoothedValue = 0.0;
}

LowPassFilter::~LowPassFilter() {
}


void LowPassFilter::setData(long dataPoint) {
    getChain()->setData(dataPoint);
    smoothedValue = (getChain()->getData() * (1.0 - _alpha)) + (smoothedValue * _alpha);
}

long LowPassFilter::getData() const {
    return smoothedValue;
}

