#ifndef AUTOSCALE_H
#define AUTOSCALE_H

#include "mbed.h"
#include "AnalogFilterInterface.h"

/**
Auto scale a analog input to it's desired min/max values
This is handy of you connect a potentiometer to a analog input where you cannot make the full values, but
your flight simulator expects full values
**/
class AutoScale : public AnalogFilterInterface
{
private:
    const long _expectedMax;
    const long _expectedMin;
    long _currentMax;
    long _currentMin;
    long _current;
    double _a;
    double _b;
    double _mul;
public:
    AutoScale(AnalogFilterInterface *chain,long expectedMin, long expectedMax);
    AutoScale(AnalogFilterInterface *chain,long expectedMin, long expectedMax, double multiplier);
    ~AutoScale();

    virtual void setData(long data);
    virtual long getData() const;
private:
    void reCalc();
};

#endif