#ifndef ANALOGINFILTERED_H
#define ANALOGINFILTERED_H

#include "mbed.h"
#include "AnalogFilterInterface.h"

/**
Analog input, this reads a analog value from a PIN and send the data through the filterchain
*/
class AnalogInFiltered : public AnalogFilterInterface {
    private:
        AnalogIn *_ain;
        const int _fuzzyFactor;
        AnalogFilterInterface   *_filter;
        long   _lastValue;
    public:   
        /**
        filter : Failter chain
        pin : Analog input to read
        */
        AnalogInFiltered(AnalogFilterInterface *filter, PinName pin, int fuzzyFactor);
        ~AnalogInFiltered();
        
        // Read a value from analog in
        virtual void setData(long data);
        virtual long getData() const;
        
        // Test if the input value is changed based on a offset
        bool getIsChanged();
        
        int getFuzzyFactor();
};

#endif