#include "mbed.h"
#include "C12832.h"


C12832 lcd(D11, D13, D12, D7, D10);

AnalogIn pot1 (A0);
AnalogIn pot2 (A1);

PwmOut r (D5);
PwmOut g (D8);
PwmOut b (D9);

int main()
{
    Serial pc(USBTX,USBRX);
   
    while(1) {
          lcd.cls();
        lcd.locate(0,15);
        lcd.printf("Pot 1 = %.2f", (float)pot1);
        lcd.locate(0,14);
        float i = (float)pot1; 
        float p  = 3 * i;
        r = 1.0 - ((p < 1.0) ? 1.0 - p : (p > 2.0) ? p - 2.0 : 0.0);
        g = 1.0 - ((p < 1.0) ? p : (p > 2.0) ? 0.0 : 2.0 - p);
        b = 1.0 - ((p < 1.0) ? 0.0 : (p > 2.0) ? 3.0 - p : p - 1.0);  ;  
        wait (0.01);
                
    }
}
