#include "PGA112_Driver.h"


PGA112::PGA112(SPI *SPI_BUS, DigitalOut *Chip_Select)
{
  PGA = SPI_BUS;
  CS = Chip_Select;
  gain = 1;
  channel = 1;
  CS->write(1);
}

void PGA112::set_gain(int gain_set)
{
  char temp = 0x00;
  gain = gain_set;

  switch(gain)
  {
    case 1:
        temp = GAIN_1<<4;
        break;
    case 2:
        temp = GAIN_2<<4;
        break;
    case 4:
        temp = GAIN_4<<4;
        break;
    case 8:
        temp = GAIN_8<<4;
        break;
    case 16:
        temp = GAIN_16<<4;
        break;
    case 32:
        temp = GAIN_32<<4;
        break;
    case 64:
        temp = GAIN_64<<4;
        break;
    case 128:
        temp = GAIN_128<<4;
        break;
  }
  switch(channel)
  {
    case 0:
        gain_chan = temp + VCAL_CH0;
        break;
    case 1:
        gain_chan = temp + CH_1;
        break;
    case 12:
        gain_chan = temp + CAL_1;
        break;
    case 13:
        gain_chan = temp + CAL_2;
        break;
    case 14:
        gain_chan = temp + CAL_3;
        break;
    case 15:
        gain_chan = temp + CAL_4;
        break;
  }
  CS->write(0);
  PGA->write(CMD_WRITE);
  PGA->write(gain_chan);
  CS->write(1);
}

void PGA112::set_channel(int channel_set)
{
  char temp = 0x00;
  channel = channel_set;

  switch(gain)
  {
    case 1:
        temp = GAIN_1<<4;
        break;
    case 2:
        temp = GAIN_2<<4;
        break;
    case 4:
        temp = GAIN_4<<4;
        break;
    case 8:
        temp = GAIN_8<<4;
        break;
    case 16:
        temp = GAIN_16<<4;
        break;
    case 32:
        temp = GAIN_32<<4;
        break;
    case 64:
        temp = GAIN_64<<4;
        break;
    case 128:
        temp = GAIN_128<<4;
        break;
  }
  switch(channel)
  {
    case 0:
        gain_chan = temp + VCAL_CH0;
        break;
    case 1:
        gain_chan = temp + CH_1;
        break;
    case 12:
        gain_chan = temp + CAL_1;
        break;
    case 13:
        gain_chan = temp + CAL_2;
        break;
    case 14:
        gain_chan = temp + CAL_3;
        break;
    case 15:
        gain_chan = temp + CAL_4;
        break;
  }
  CS->write(0);
  PGA->write(CMD_WRITE);
  PGA->write(gain_chan);
  CS->write(1);
}
