#ifndef PGA112_DRIVER_H
#define PGA112_DRIVER_H
#include "mbed.h"
#define CMD_WRITE 0x2A

#define GAIN_1    0x0
#define GAIN_2    0x1
#define GAIN_4    0x2
#define GAIN_8    0x3
#define GAIN_16   0x4
#define GAIN_32   0x5
#define GAIN_64   0x6
#define GAIN_128  0x7

#define CAL_1     0xC // Channel 12
#define CAL_2     0xD // Channel 13
#define CAL_3     0xE // Channel 14
#define CAL_4     0xF // Channel 15
#define VCAL_CH0  0x0 // channel 0
#define CH_1      0x1 // channel 1


/** This is library to drive the PGA112. Basic funcitons have been implemented.
*
*/

class PGA112
{
public:
  /** Create a PGA object
  * This takes a pointer object of an SPI bus. Becareful, this is not thread safe
  * and may cause hanging
  *
  *  @param SPI_BUS pointer to SPI object
  *  @param Chip_Select chip select line for the PGA. pointer plz
  */
  PGA112(SPI *SPI_BUS, DigitalOut *Chip_Select);
  /** This will set the gain for the PGA
  *  Please only use binary gains.....1,2,4,8,16,32,64,128
  *
  * @param gain_set parameter to set gain, see comment for acceptable gain values
  */
  void set_gain(int gain_set);
  /** Sets the channel selection
  *  - CAL_1     0xC // Channel 12  GND
  *  - CAL_2     0xD // Channel 13  0.9*Vcal
  *  - CAL_3     0xE // Channel 14  0.1*Vcal
  *  - CAL_4     0xF // Channel 15  Vref (2.5000 volts)
  *  - VCAL_CH0  0x0 // channel 0   Vcal (5.0000 volts)
  *  - CH_1      0x1 // channel 1
  *
  * @param channel_set the channel you want to select. See above table for values
  */
  void set_channel(int channel_set);
  /** Sets the channel to CAL1 channel which is connected to GND
  */
  void set_CAL1();
  /** Sets the channel to CAL2 channel which is connected to 0.9*Vcal (Vcal = 5)
  */
  void set_CAL2();
  /** Sets the channel to CAL3 channel which is connected to 0.1*Vcal (Vcal = 5)
  */
  void set_CAL3();
  /** Sets the channel to CAL4 channel which is connected to Vref (2.5V)
  */
  void set_CAL4();
private:
  SPI *PGA;
  DigitalOut *CS;
  int gain;
  int channel;
  char gain_chan;
};
#endif
