
#include "DACxx6xT.h"


DACxx6xT::DACxx6xT(SPI *A, float Vref = 3.3)
{
  DACC = A;
  numslaves = 0;
  vref_A = Vref;
  vrefpin = Vref;
  gain_DAC_A = 1.0;
  gain_DAC_B = 1.0;
  custom_gain_A = 1.0;
  custom_gain_B = 1.0;
  vref_B = Vref;
}

DACxx6xT::DACxx6xT(SPI *A, DigitalOut *device_CS, float Vref = 3.3)
{
  DACC = A;
  CS = device_CS;
  CS->write(1);
  vref_A = Vref;
  vref_B = Vref;
  vrefpin = Vref;
  gain_DAC_A = 1.0;
  gain_DAC_B = 1.0;
  custom_gain_A = 1.0;
  custom_gain_B = 1.0;
}

void DACxx6xT::init()
{
  CS->write(0);
  DACC->write(RESET_ALL_REG_UPDATE_ALL>>16);
  DACC->write(RESET_ALL_REG_UPDATE_ALL>>8);
  DACC->write(RESET_ALL_REG_UPDATE_ALL);
  CS->write(1);
}


void DACxx6xT::write(short value, int dacnum)
{

  CS->write(0);
  if(dacnum == 1) //write to DAC A
  {
    DACC->write(WRITE_DAC_A_REG_UPDATE_A);//Write to DAC-A input register and update DAC-A
    DACC->write(value>>8); //send top 8 bits
    DACC->write(value); //send buttom 8 bits
  }
  else if(dacnum == 2)
  {
    DACC->write(WRITE_DAC_B_REG_UPDATE_B);//Write to DAC-A input register and update DAC-A
    DACC->write(value>>8); //send top 8 bits
    DACC->write(value); //send buttom 8 bits
  }
  CS->write(1);
}

void DACxx6xT::set_DAC_gain(short gain, int dacnum)
{
    if(dacnum == 1)
    {
      gain_DAC_A = gain;
    }
    else if(dacnum == 2)
    {
      gain_DAC_B = gain;
    }
    CS->write(0);
    if(gain_DAC_A == 1 && gain_DAC_B == 1)//Gain: DAC-B gain = 1, DAC-A gain = 1 (power-on default)
    {
      DACC->write(DAC_B_G1_DAC_A_G1>>16);
      DACC->write(DAC_B_G1_DAC_A_G1>>8);
      DACC->write(DAC_B_G1_DAC_A_G1);
      gain_DAC_A = 1;
      gain_DAC_B = 1;
    }
    else if(gain_DAC_A == 2 && gain_DAC_B == 1)//Gain: DAC-B gain = 1, DAC-A gain = 2
    {
      DACC->write(DAC_B_G1_DAC_A_G2>>16);
      DACC->write(DAC_B_G1_DAC_A_G2>>8);
      DACC->write(DAC_B_G1_DAC_A_G2);
      gain_DAC_A = 2;
      //vref_A = 2.5;
      gain_DAC_B = 1;
    }
    else if(gain_DAC_A == 1 && gain_DAC_B == 2)//Gain: DAC-B gain = 2, DAC-A gain = 1
    {
      DACC->write(DAC_B_G2_DAC_A_G1>>16);
      DACC->write(DAC_B_G2_DAC_A_G1>>8);
      DACC->write(DAC_B_G2_DAC_A_G1);
      gain_DAC_A = 1;
      gain_DAC_B = 2;
      //vref_B = 2.5;
    }
    else if(gain_DAC_A == 2 && gain_DAC_B == 2)//Gain: DAC-B gain = 2, DAC-A gain = 2
    {
      DACC->write(DAC_B_G2_DAC_A_G2>>16);
      DACC->write(DAC_B_G2_DAC_A_G2>>8);
      DACC->write(DAC_B_G2_DAC_A_G2);
      gain_DAC_A = 2;
      //vref_A = 2.5;
      gain_DAC_B = 2;
      //vref_B = 2.5;
    }
    CS->write(1);
}

void DACxx6xT::enable_internal_vref()//Enable internal reference and reset DACs to gain = 2
{
  CS->write(0);
  DACC->write(EN_INTREF_GAIN2_ALL>>16);
  DACC->write(EN_INTREF_GAIN2_ALL>>8);
  DACC->write(EN_INTREF_GAIN2_ALL);
  vref_A = INTERNAL_VREF;
  vref_B = INTERNAL_VREF;
  gain_DAC_B = 2;
  gain_DAC_A = 2;
  CS->write(1);
}

void DACxx6xT::disable_internal_vref()//Disable internal reference and reset DACs to gain = 1
{
  CS->write(0);
  DACC->write(DIS_INTREF_GAIN1_ALL>>16);
  DACC->write(DIS_INTREF_GAIN1_ALL>>8);
  DACC->write(DIS_INTREF_GAIN1_ALL);
  vref_A = vrefpin;
  vref_B = vrefpin;
  CS->write(1);
}

void DACxx6xT::set_custom_gain(float value, int dacnum)
{
  if(dacnum == 1)
  {
    custom_gain_A = value;
  }
  else if(dacnum == 2)
  {
    custom_gain_B = value;
  }

}
void DACxx6xT::write_voltage(float value, int dacnum)
{
  if(dacnum == 1)
  {
    write(static_cast<int>((value/(vref_A*gain_DAC_A*custom_gain_A))*65535.0), 1);
  }
 if(dacnum == 2)
  {
    write(static_cast<int>((value/(vref_B*gain_DAC_B*custom_gain_B))*65535.0), 2);
  }
}
