#ifndef DACXX6XT_DRIVER_H
#define DACXX6XT_DRIVER_H

#include "mbed.h"

#define WRITE_DAC_A_REG 0x00 //Write to DAC-A input register
#define WRITE_DAC_B_REG 0x01 //Write to DAC-B input register
#define WRITE_DAC_AB_REG 0x07  //Write to DAC-A and DAC-B input registers
#define WRITE_DAC_A_REG_UPDATE_ALL 0x10 //Write to DAC-A input register and update all DACs
#define WRITE_DAC_B_REG_UPDATE_ALL 0x11  //Write to DAC-B input register and update all DACs
//#define WRITE_DAC_AB_REG_UPDATE_ALL 0x17 //Write to DAC-A and DAC-B input register and update all DACs
#define WRITE_DAC_A_REG_UPDATE_A 0x18 //Write to DAC-A input register and update DAC-A
#define WRITE_DAC_B_REG_UPDATE_B 0x19 //Write to DAC-B input register and update DAC-B
#define WRITE_DAC_AB_REG_UPDATE_ALL 0x1F //Write to DAC-A and DAC-B input register and update all DACs
#define UPDATE_DAC_A 0x08 //Update DAC-A
#define UPDATE_DAC_B 0x09 //Update DAC-B
#define UPDATE_ALL_DACS 0x0F //Update all DACs
#define DAC_B_G2_DAC_A_G2 0x020000 //0 Gain: DAC-B gain = 2, DAC-A gain = 2 (default with internal VREF)
#define DAC_B_G2_DAC_A_G1 0x020001 //Gain: DAC-B gain = 2, DAC-A gain = 1
#define DAC_B_G1_DAC_A_G2 0x020002 //Gain: DAC-B gain = 1, DAC-A gain = 2
#define DAC_B_G1_DAC_A_G1 0x020003 //Gain: DAC-B gain = 1, DAC-A gain = 1 (power-on default)
#define POWERUP_DAC_A 0x200001 //Power up DAC-A
#define POWERUP_DAC_B 0x200002 //Power up DAC-B
#define POWERUP_ALL_DAC 0x200003 //Power up DAC-A and DAC-B
#define POWERDOWN_DAC_A_1K 0x020009 //Power down DAC-A; 1 kΩ to GND
#define POWERDOWN_DAC_B_1K 0x02000A //Power down DAC-B; 1 kΩ to GND
#define POWERDOWN_DAC_ALL_1K 0x02000B //Power down DAC-A and DAC-B; 1 kΩ to GND
#define POWERDOWN_DAC_A_100K 0x0200011 // Power down DAC-A; 100 kΩ to GND
#define POWERDOWN_DAC_B_100K 0x0200012 // Power down DAC-B; 100 kΩ to GND
#define POWERDOWN_DAC_ALL_100K 0x0200013 // Power down DAC-A and DAC-B; 100 kΩ to GND
#define POWERDOWN_DAC_A_HIZ 0x0200019 //Power down DAC-A; Hi-Z
#define POWERDOWN_DAC_B_HIZ 0x020001A //Power down DAC-B; Hi-Z
#define POWERDOWN_DAC_ALL_HIZ 0x020001B //Power down DAC-A and DAC-B; Hi-Z
#define RESET_DAC_ALL_UPDATE_ALL 0x280000 //Reset DAC-A and DAC-B input register and update all DACs
#define RESET_ALL_REG_UPDATE_ALL 0x280001 //Reset all registers and update all DACs (Power-on-reset update)
#define LDAC_ACTAB 0x300000 // LDAC pin active for DAC-B and DAC-A
#define LDAC_ACTB_ONLY 0x300001 //LDAC pin active for DAC-B; inactive for DAC-A
#define LDAC_ACTA_ONLY 0x300002 //LDAC pin inactive for DAC-B; active for DAC-A
#define LDAC_IVACTIVE_ALL 0x300003 //LDAC pin inactive for DAC-B and DAC-A
#define DIS_INTREF_GAIN1_ALL 0x380000 //Disable internal reference and reset DACs to gain = 1
#define EN_INTREF_GAIN2_ALL 0x380001 //Enable internal reference and reset DACs to gain = 2
#define INTERNAL_VREF 2.5 //Internal voltage reference

/** This is a driver for the DACxx6xT series of Texas instruments DACs
*/
class DACxx6xT
{
public:
  DACxx6xT(SPI *A, float Vref);
    /** Create a DACxx6xT device class
    *
    *  Constructor for the DACxx6xT class
    *
    *  @param A SPI object pointer, this is the SPI bus the DAC is one
    *  @param Vref for the external voltage reference you are using. The default is 3.3V.
    */
  DACxx6xT(SPI *A, DigitalOut *device_CS, float Vref);
    /** This funciton can be run to initialize everything to its default state
    */
  void init();
    /** Write a value to the DAC
    *
    *  The number written to do the DAC will be a 16 bit number regardless of
    *  whether the part is 12,14, or 16 bit. This maintains forward and backward
    *  compatibility between the parts.
    *
    *  @param value 16 bit value to be written to DAC
    *  @param dacnum pick between DAC A or B. DAC A = 1, DAC B = 2
    *  @param daccs choose which device number you want to select
    */
  void write(short value, int dacnum);

    /** Sets the internal gain on the DACs. The default gain on the DACs
    * is 1 and it uses the external reference for refence
    *
    *  @param dac select the DAC for gain change 1 for DAC A and 2 DAC B
    *  @param gain gain you want. 1 for 1 and 2 for 2
    */
  void set_DAC_gain(short gain, int dacnum);

  void enable_internal_vref();
  void disable_internal_vref();
  void write_voltage(float value, int dacnum);
  void set_custom_gain(float value, int dacnum);
private:
  int numslaves;
  DigitalOut *CS;
  float vref_A;
  float vref_B;
  float vrefpin;
  float gain_DAC_A;
  float gain_DAC_B;
  float custom_gain_A;
  float custom_gain_B;
  SPI *DACC;
};

#endif
