#ifndef AD7989_H
#define AD7989_H

#include "mbed.h"
   /** An abstraction for an 18 bit ADC
    *  @note Not quite sure this is thread or interrupt safe. Treat this as a standard mbed SPI object
    *  There are mutex locks when the SPI bus is being used.
    *
    *  Example:
    *  @code
    *  #include "mbed.h"
    *  #include "AD7989_Driver.h"
    *
    *  SPI spi(p5, p6, p7); // mosi, miso, sclk
    *  DigitalOut cs(p8);
    *  Digitalout convert(p9);
    *  AD7989_Driver ADCDEV(&spi, &cs, &convert);
    *  double voltage;
    *  int main()
    *  {
    *    while(1)
    *    {
    *      voltage = ADCDEV.sample();
    *      printf("Voltage = %f Volts", voltage);
    *    }
    *  }
    *  @endcode
    */
class AD7989_Driver
{
public:
  /** Constructor for AD7989_Drive object
  *
  *  @param SPI_BUS this is the SPI bus the AD7989 is one
  *  @param Chip_Select this is the DigitalOut outline connected to CS pin
  *  @param Convert this is the DigitalOut pin that is connected to the CONV pin
  */
  AD7989_Driver(SPI *SPI_BUS, DigitalOut *Chip_Select, DigitalOut *Convert);
  /** Function returns the voltage on the AD7989 as a double
  *  The value the function will return will be from -5.0V to 5.0V
  */
  double sample();
  /** Averages a number of samples the user specifies
  *
  *  @param num_avgs The number of samples to average
  */
  double sample_avg(int num_avgs);

  float volts;
private:
  static const float zero_point;
  SPI *ADC_SPI;
  DigitalOut *CS;
  DigitalOut *ADC_CONV;
};

#endif
