#include "AD7989.h"

const float AD7989_Driver::zero_point = 5.0;

AD7989_Driver::AD7989_Driver(SPI *SPI_BUS, DigitalOut *Chip_Select,  DigitalOut *Convert)
{
  ADC_SPI = SPI_BUS;
  CS = Chip_Select;
  ADC_CONV = Convert;
}

double AD7989_Driver::sample()
{
  long raw;
  long bits;
  ADC_CONV->write(1);
  wait_us(2);
  CS->write(0);
  raw = 0;
  bits = (ADC_SPI->write(0x00)) << 16;
  //printf("First Octet = 0x%X \n",bits);
  raw = bits;
  bits = 0;
  bits = (ADC_SPI->write(0x00)) << 8;
  //printf("Second Octet = 0x%X \n",bits);
  raw = bits + raw;
  bits = 0;
  bits = (ADC_SPI->write(0x00));
  CS->write(1);
  ADC_CONV->write(0);
  //printf("Third Octet = 0x%X \n",bits);
  raw = bits + raw;
  bits = 0;
  raw = raw >> 6;
  //converts 2's complement 18 bit number into a 32 bit signed 2's complement number
  raw = (raw >> 17) == 0 ? raw : (0xFFFFFFFF ^ 0x3FFFF) | raw;
  volts = (static_cast<double>(raw)/(pow(2.0,18)));
  volts = (volts*10.0)-zero_point; //This assumed you are using a 5 volt Vref
  //pc.printf("%f \n", volts);
  return volts;
}

double AD7989_Driver::sample_avg(int num_avgs)
{
  double temp = 0.0;
  for(int i = 0; i < num_avgs; i++)
  {
    temp = temp + sample();
  }
  temp = temp/num_avgs;
}
