#include "mbed.h"
#include "zbee.h"
#include "C12832_lcd.h"

DigitalOut myled(LED1);

AnalogIn pot1(p19);         // Pot 1
AnalogIn pot2(p20);         // Pot 2

zbee zbee1(p9,p10,ZBEE_BAUD); 
C12832_LCD lcd;


char txt[40];               // text to send
char pot1_txt[20];          // text buffer for pot1 value
char pot2_txt[20];          // text buffer for pot2 value

int main() {
    

    while(1) {
        
        lcd.cls();          // clear lcd screen
        lcd.locate(1,1);    // text location x=1,y=1
                
        sprintf(pot1_txt,"pot1=%.2f", pot1.read()); // read pot1 value and convert to text
        sprintf(pot2_txt,"pot2=%.2f", pot2.read()); // read pot2 value and convert to text
        sprintf(txt,"#%s %s",pot1_txt, pot2_txt);   // put them together for sending
        
        zbee1.SendData(txt);                        // send text
        
        lcd.printf("TX -> %s %s\r",pot1_txt,pot2_txt);  // update lcd display
        
        wait(1);                                        // delay for 1s
  }
}
