#include "mbed.h"
#include "zbee.h"
#include "C12832_lcd.h"

DigitalOut myled(LED1);
zbee zbee1(p9,p10,ZBEE_BAUD); 
C12832_LCD lcd;

char text[50];  // buffer read
char delimiter[1];  // for synchonisation

float pot1; // pot1 value
float pot2; // pot2 value

int main() {

    while(1) {
        
        while(delimiter[0]!='#') {      // synchronisation with '#'
            zbee1.ReceiveData(delimiter,1);   // read a character for '#'
        }
        
        zbee1.ReceiveData(text,20);                 // "#pot1=x.xx pot2=x.xx"
        
        sscanf(text,"#pot1=%f pot2=%f",&pot1, &pot2);   // parse pot1 and pot2 values from text received
        
        lcd.cls();  // clear lcd screen
        lcd.locate(1,1);    // lcd location x=1,y=1
        lcd.printf("RX -> pot1=%.2f pot2=%.2f\n",pot1, pot2); // update lcd values of pot1 and pot2
        lcd.printf("pot1 + pot2 = %.2f",pot1+pot2); // summation of two values
        wait(0.1);                    // delay for 0.1s
    }
}
