/* Copyright (c) 2016 Ruslee Sutthaweekul, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "zbee.h"


zbee::zbee(PinName tx, PinName rx, int baud)
{
    _tx = tx;
    _rx = rx;
    _baud = baud;
}

zbee::~zbee()
{
}


int zbee::GetAddr(char *addr)
{
    Serial DATA(_tx,_rx);
    DATA.baud(_baud);
    wait_ms(50);
    DATA.printf("AT+GETADDR \r");
    DATA.scanf ("%s",addr);
    return 1;
}

int zbee::GetPanId(char *panid)
{
    Serial DATA(_tx,_rx);
    DATA.baud(_baud);
    wait_ms(50);
    DATA.printf("AT+GETPANID \r");
    DATA.scanf ("%s",panid);
    return 1;
}


int zbee::SendData(char *data_buf)
{
    Serial DATA(_tx,_rx);
    DATA.baud(_baud);
    
    DATA.printf("%s",data_buf);
 //   DATA.scanf ("%*s");         // flush
    return 1;
}

void zbee::ReceiveData(char *data_buf, int numchar)
{
    int count=0;
    if(numchar == 0) {
        numchar = sizeof(data_buf);
    }
    Serial DATA(_tx,_rx);
    DATA.baud(_baud);
    while(numchar!=count) {
        if(DATA.readable()) {
            *data_buf = DATA.getc();
            data_buf+=1;
            count++;
        }

    }
}

int zbee::SetPanId(int pan_id)
{
    Serial DATA(_tx,_rx);
    DATA.baud(_baud);
    char rx[20];
    
    wait_ms(5);
    
    DATA.printf("AT+SETPANID %i\r",pan_id);
    DATA.scanf ("%*s",rx);
    
    if(strcmp(rx,"SETPANID OK"))
        return 1;
    else
        return 0;
}

void zbee::Reset()
{
    Serial DATA(_tx,_rx);
    DATA.baud(_baud);
    wait_ms(50);
    DATA.printf("AT+RESET \r");
    DATA.scanf ("%*s");
}


