/* Copyright (c) 2016 Ruslee Sutthaweekul, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#include "mbed.h"
#define ZBEE_BAUD 38400

/** Zbee interface class for configuring, sending and recieving data using an waveshare Zbee */

class zbee
{
private:
    PinName _tx;
    PinName _rx;
    PinName _reset;
    int _baud;
    
public:
    /** Configure serial data pin.
      * @param tx The serial tx pin the xbee is conected to.
      * @param rx The serial rx pin the xbee is conected to.
      * @param reset The pin connected to the Xbee reset pin.
      */
    zbee(PinName tx, PinName rx, int baud);
    ~zbee();
    /** Puts the Xbee into config mode.
      * @return Returns 1 on success.
      */

    int GetAddr(char*);
    /** Sets the encryption key to the one stored in security_key.
      * @param key Pointer to the network key to set.
      * @return Returns 1 on success.
      */
    int GetPanId(char*);
    /** Sets the encryption key to the one stored in security_key.
      * @param key Pointer to the network key to set.
      * @return Returns 1 on success.
      */
    int SetPanId(int);
    /** Sets the encryption key to the one stored in security_key.
      * @param PanId Pointer to the network key to set.
      * @return Returns 1 on success.
      */    
      
    int SendData(char*);
    /** Recieves data sent to the xbee.
      * @param data_buf Pointer to the buffer to put recieved data into.
      * @param numchar Number of characters to read. If 0, will use the size of data_buf.
      */
    void ReceiveData(char*, int);
        /** Resets the Xbee.
      */
    void Reset();

};