#include <global.h>

Serial RS2(UART2_TX, UART2_RX);
Serial RS1(UART1_TX, UART1_RX);

Timer timer;
Watchdog  watchDog;

typedef uint8_t byte;

DigitalOut Select1(DE_TXD_1);
DigitalOut Select2(DE_TXD_2);

bool sendFlag = false;
char c = '1';

// ----------------------------- For future ---------------------------------------
// Counting CRC for modbus package
//const unsigned char CRC7_POLY = 0x91;

//unsigned char getCRC(unsigned char message[], unsigned char length)
//{
//    unsigned char i, j, crc = 0;
//
//    for (i = 0; i < length; i++) {
//        crc ^= message[i];
//        for (j = 0; j < 8; j++) {
//            if (crc & 1)
//                crc ^= CRC7_POLY;
//            crc >>= 1;
//        }
//    }
//    return crc;
//
//}

void UART2_callback()
{
    c =  RS2.getc();
    if(c == '5') {
        sendFlag = true;
    } else {
        Select2 = 1;
        wait_ms(90);
        Select2 = 0;
    }
}

int main()
{
    RS2.baud (115200);
    RS1.baud (115200);
    Select1 = 0;
    Select2 = 0;
    RS2.attach(&UART2_callback);

#if MAIN_CODE
    int US1_data = 0,US2_data = 0, US3_data = 0, Lift_IR1 = 0,Lift_IR2 = 0, Enc_left_data = 0, Enc_right_data = 0;
    bool IR1_data = 0,IR2_data = 0;
    float temp_one_value = -1, temp_two_value = -1, currentTime = 0, previousTime = 0;
    
    timer.start();

    watchDog.Configure(5.0);

    OneWire oneWire(PA_11);        // substitute D8 with the actual pin name connected to the 1-wire bus
    int sensorsFound = 0;

    DigitalIn  Lift1 (PB_0);
    DigitalIn  Lift2 (PB_1);

    AS5045 Enc_left(SP1_NSS1);
    AS5045 Enc_right(SP1_NSS2);

    JSN_SR04 US_sensor_left (PB_14, PA_9);
    JSN_SR04 US_sensor_middle (PB_15, PA_9);
    JSN_SR04 US_sensor_right (PA_8, PA_9);

    US_sensor_left.setRanges (20, 300);
    US_sensor_middle.setRanges (20, 300);
    US_sensor_right.setRanges (20, 300);

    E18_D80NK IR_sensor_left (PB_13);
    E18_D80NK IR_sensor_right (PB_12);

    for (sensorsFound = 0; sensorsFound < MAX_SENSOSRS; sensorsFound++) {
        ds1820[sensorsFound] = new DS1820(&oneWire);
        if (!ds1820[sensorsFound]->begin()) {
            delete ds1820[sensorsFound];
            break;
        }
    }

    while (true) {
        watchDog.Service();
        
        currentTime = timer.read();

        if((currentTime - previousTime) >= 0.1) {
            previousTime = currentTime;
            
            for (int i = 0; i < sensorsFound; i++) {
                ds1820[i]->startConversion();
                wait_ms(1);
            }

            US_sensor_left.startMeasurement ();
            US1_data = US_sensor_left.getDistance_cm ();
            wait_ms(20);
            
            US_sensor_middle.startMeasurement ();
            US2_data = US_sensor_middle.getDistance_cm ();
            wait_ms(20);
            
            US_sensor_right.startMeasurement ();
            US3_data = US_sensor_right.getDistance_cm ();
            wait_ms(20);
            
            IR1_data = IR_sensor_left.checkObstacle ();
            IR2_data = IR_sensor_right.checkObstacle ();
            
            Lift_IR1 = Lift1.read();
            Lift_IR2 = Lift2.read();


            if (ds1820[0]->isPresent() ) {
                temp_one_value = ds1820[0]->read();
            }
            if (ds1820[1]->isPresent() ) {
                temp_two_value = ds1820[1]->read();
            }
        }

        Enc_left_data = Enc_left.getPosition();
        Enc_right_data = Enc_right.getPosition();
        
        Select1 = 1;
        RS1.printf ("%d\r\n", Enc_left_data);//, Enc_right_data);
        wait_ms(1);
        Select1 = 0;

        if(sendFlag) {
            Select2 = 1;
            RS2.printf ("%d_%d_%d_%d_%d_%d_%d_%3.1f_%3.1f\r\n", US1_data, US2_data, US3_data, IR1_data, IR2_data, Lift_IR1, Lift_IR2, temp_one_value, temp_two_value);  //,(int)((Vcc -24 ) * 5 + 50));
            wait_ms(5);
            sendFlag = false;
            Select2 = 0;
        }
    }
#endif

#if TEST_REQUEST

    while (true) {
        // if(RS1.readable()) {
//            Select1 = 1;
//            RS1.putc(RS1.getc());
//            wait_ms (1000);
//            Select1 = 0;
//        }else{
        Select1 = 1;
        RS1.printf ("nothing \n");
        wait_ms (5);
        Select1 = 0;
        wait_ms (1000);
        //}
    }

#endif

}