#include <global.h>

Serial RS2(UART2_TX, UART2_RX);

Timer timer;
Watchdog  watchDog;

typedef uint8_t byte;

DigitalOut Select2(DE_TXD_2);

bool sendFlag = false;
char c = '1';

void UART2_callback()
{
    c =  RS2.getc();
    if(c == '5') {
        sendFlag = true;
    } else {
        Select2 = 1;
        wait_ms(90);
        Select2 = 0;
    }
}

int main()
{
    RS2.baud (115200);
    Select2 = 0;
    RS2.attach(&UART2_callback);

    int US1_data = 0;
    bool IR_FR_data = 0,IR_FL_data = 0, IR_BR_data = 0,IR_BL_data = 0, Bak_data = 0;

    timer.start();
    watchDog.Configure(5.0);

    JSN_SR04 US_sensor_left (PB_14, PA_9);

    US_sensor_left.setRanges (20, 300);

    DigitalIn  Bak_limit_sensor (PA_11);
    E18_D80NK IR_sensor_front_left (PB_13);
    E18_D80NK IR_sensor_front_right (PB_12);
    E18_D80NK IR_sensor_back_right (PB_0);
    E18_D80NK IR_sensor_back_left (PB_1);


    while (true) {
        watchDog.Service();

        US_sensor_left.startMeasurement ();
        US1_data = US_sensor_left.getDistance_cm ();
        wait_ms(20);

        Bak_data = Bak_limit_sensor.read();
        IR_FL_data = IR_sensor_front_left.checkObstacle ();
        IR_FR_data = IR_sensor_front_right.checkObstacle ();
        IR_BR_data = IR_sensor_back_right.checkObstacle ();
        IR_BL_data = IR_sensor_back_left.checkObstacle ();

        if(sendFlag) {
            Select2 = 1;
            RS2.printf ("%d_%d_%d_%d_%d_%d\r\n", IR_FL_data, IR_FR_data, IR_BR_data, IR_BL_data, Bak_data, US1_data);  //,(int)((Vcc -24 ) * 5 + 50));
            wait_ms(5);
            sendFlag = false;
            Select2 = 0;
        }
    }
}